/*!
  \file
  \brief Ñj[

  \author Satofumi KAMIMURA

  $Id$

  \todo |bvAbvŃj[ڂ̐s
  \todo j[̐
  \todo [UACȒAOptionMenu ƍ킹
*/

#include "FirstMenu.h"
#include "FirstMenu_uni.h"
#include "hyakutyping.h"
#include "DrawsDefinition.h"
#include "CommonResources.h"
#include "ResourceDefinition.h"
#include "PracticeMenu.h"
#include "NetworkMenu.h"
#include "ViewHistory.h"
#include "OptionMenu.h"
#include "UserMenu.h"
#include "user_bmp.h"
#include "white_bmp.h"
#include "AccessSettings.h"
#include "GuiManager.h"
#include "Layer.h"
#include "SdlSurface.h"
#include "MultiSurface.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "LabelComponent.h"
#include "ButtonComponent.h"
#include "MenuComponent.h"
#include "ComboBoxComponent.h"
#include "InputHandler.h"
#include "CreateSurfaceFromArray.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct FirstMenu::pImpl {
  CommonResources* common;
  TtfResource* font;
  TextProperty title_property;
  Surface title_surface;
  Component title_label;
  boost::shared_ptr<MenuComponent> menu;
  TextProperty version_property;
  Surface version_surface;
  Component version_label;

  Surface user_bmp_surface;
  Surface white_bmp_surface;
  boost::shared_ptr<MultiSurface> focus_surface;
  boost::shared_ptr<ButtonComponent> user_button;

  //Component user_label;

  boost::shared_ptr<ComboBoxComponent> user_combobox;

  pImpl(void)
    : common(CommonResources::getObject()),
      title_property(common->font, FirstMenu_title, TitleSize,
                     Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)), menu(new MenuComponent),
      version_property(common->font, VersionText, NormalSize,
                       Fore, Back, true),
      version_surface(new TextSurface(version_property)),
      version_label(new LabelComponent(version_surface)),
      user_bmp_surface(new SdlSurface(createSurface(user_bmp,
                                                    user_bmp_width,
                                                    user_bmp_height), true)),
      white_bmp_surface(new SdlSurface(createSurface(white_bmp,
                                                    white_bmp_width,
                                                    white_bmp_height), true)),
      focus_surface(new MultiSurface(white_bmp_width, white_bmp_height)),
      user_button(new ButtonComponent),
      user_combobox(new ComboBoxComponent)
  {

    // o[Ẅʒuݒ
    SDL_Rect position;
    set_SdlRect(&position, TextOffset, TextOffset);
    version_label->setPosition(&position);

    // ^Cg̈ʒuݒ
    set_SdlRect(&position, centerPosition(title_label, 640/2),
                middlePosition(title_label, 480/4));
    title_label->setPosition(&position);

    // j[ڂ̍쐬
    const Uint16 *titles[] = {
      FirstMenu_practice, FirstMenu_network, FirstMenu_history,
      FirstMenu_option, FirstMenu_quit,
    };

    // !!! ̃j[鏈́ACommonResource ̊֐ŏ悤
    size_t max_width = 0;
    for (size_t i = 0; i < sizeof(titles)/sizeof(titles[0]); ++i) {

      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      TextProperty normal(common->font, titles[i], MenuSize,
                          Fore, Back, true);
      TextProperty selected(common->font, titles[i], MenuSize,
                            Selected, Back, true);
      ButtonComponent::createButton(new_button, normal, selected, selected);
      if (new_button->getWidth() > max_width) {
        max_width = new_button->getWidth();
      }
      menu->addItem(new_button);
    }
    menu->setItemsOffset(0, MenuSize + 16);
    menu->setItemSelectWidth(max_width);
    menu->setSelected(0);
    menu->setIconComponent(common->menu_icon, IconOffset, 0, Middle | Left);

    // [U{^̍쐬
    user_button->registerNormalSurface(user_bmp_surface);
    focus_surface->registerSurface(user_bmp_surface);
    focus_surface->registerSurface(white_bmp_surface);
    user_button->registerFocusedSurface(focus_surface);
    user_button->registerPressedSurface(focus_surface);

    // R{{bNX̐ݒ
    user_combobox->setFrameColor(Pink);
    user_combobox->setDecidedBackgroundColor(Pink);
    user_combobox->setSelectedBackgroundColor(Pink);
    user_combobox->setRightOffset(TextOffset);

    set_SdlRect(&position, centerPosition(menu, 640/2), 480/4 + MenuOffset);
    menu->setPosition(&position);

    common->back_layer->push_front(common->back_label);

    set_SdlRect(&position,
                rightPosition(user_button, 640 - TextOffset), TextOffset / 2);
    user_button->setPosition(&position);
  }

  void placeComponents(void) {
    common->front_layer->push_front(version_label);
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(menu);
    common->front_layer->push_front(user_button);
    if (! common->settings->user_names_.empty()) {
      common->front_layer->push_front(user_combobox);
    }
  }

  void removeComponents(void) {
    common->front_layer->remove(version_label);
    common->front_layer->remove(title_label);
    common->front_layer->remove(menu);
    common->front_layer->remove(user_button);
    common->front_layer->remove(user_combobox);
  }

  void updateUserComboBox(void) {

    // R{{bNX̍č\z
    user_combobox->clearItems();

    TextProperty normal(common->font, "", NormalSize, Fore, Pink, false);
    TextProperty selected(common->font, "", NormalSize, Blue, Pink, false);

    for (std::vector<std::string>::iterator it
           = common->settings->user_names_.begin();
         it != common->settings->user_names_.end(); ++it) {
      normal.text = it->c_str();
      selected.text = it->c_str();

      // ڂ̓o^
      boost::shared_ptr<ButtonComponent> new_button(new ButtonComponent);
      ButtonComponent::createButton(new_button, normal, selected, selected);
      user_combobox->addItem(new_button);
    }

    // CfbNXw
    user_combobox->setSelected(static_cast<int>(common->settings->user_index_));

    // ʒuݒ
    SDL_Rect position;
    set_SdlRect(&position,
                rightPosition(user_combobox, 640) - TextOffset, TextOffset);
    user_combobox->setPosition(&position);

    position.x -= TextOffset + static_cast<int>(user_button->getWidth());
    position.y = TextOffset / 2;
    user_button->setPosition(&position);
  }

  void playDecideEffect(int selected) {

    // !!! Is\ȍڂ肵ƂɉςȂAύX
    if (selected != 4) {
      // uIv̂Ƃ͌ʉ炳Ȃ
      common->playEffect(Decide);
    }
  }
};


FirstMenu::FirstMenu(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


FirstMenu::~FirstMenu(void) {
  pimpl->removeComponents();
}


void FirstMenu::run(void) {

  // [U\̃R{{bNXĐ
  pimpl->common->updateUserLable();
  pimpl->updateUserComboBox();

  // y̍Đ
  pimpl->common->setNextMusic(BackMusic_1);

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  while (quit == false) {

    int selected = pimpl->menu->getDecided();
    bool user_config = pimpl->user_button->isDecided();
    if (0 || (selected >= 0) || user_config) {
      //selected = 3;

      // 艹炷
      pimpl->playDecideEffect(selected);
      pimpl->removeComponents();

      if (user_config) {
        // [UǗ{^ꂽƂ̏
        UserMenu user;
        user.run();

        // [UR{{bNX̍XV
        pimpl->updateUserComboBox();

        // j[̑Iڂ
        selected = 0;

      } else if (selected == 0) {
        // ^CsOK
        PracticeMenu practice;
        practice.run();

      } else if (selected == 1) {
        // lbg[Nΐ
        NetworkMenu network;
        network.run();

      } else if (selected == 2) {
        // ^CsỎ{
        ViewHistory history;
        history.run();

      } else if (selected == 3) {
        // IvV
        OptionMenu option;
        option.run();

      } else if (selected == 4) {
        // Q[̏I
        return;
      }

      // j[đI\ɂ
      pimpl->user_button->releaseDecided();
      pimpl->menu->releaseDecided();
      pimpl->menu->setSelected(selected);
      pimpl->placeComponents();
    }

    input.update_all();
    gui->update();
    quit |= input.haveQuitEvent() | input.isReleased(SDLK_ESCAPE);
    delay(1);
  }
}
