/*!
  \file
  \brief ʃ\[X̊Ǘ

  \author Satofumi KAMIMURA

  $Id$

  \todo ĨXN[[hA[UɋL^ĊǗ
*/

#include "CommonResources.h"
#include "ResourceDefinition.h"
#include "SystemDefinition.h"
#include "DrawsDefinition.h"
#include "AccessSettings.h"
#include "TypingRecorder.h"
#include "VoicePlayer.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "NullSurface.h"
#include "TextSurface.h"
#include "FillSurface.h"
#include "SdlSurface.h"
#include "AnimationSurface.h"
#include "TtfResource.h"
#include "TextProperty.h"
#include "ConsolePanelComponent.h"
#include "InputReceiveComponent.h"
#include "LabelComponent.h"
#include "SearchFilePath.h"
#include "back_bmp.h"
#include "selector_00_bmp.h"
#include "selector_01_bmp.h"
#include "selector_02_bmp.h"
#include "selector_03_bmp.h"
#include "CreateSurfaceFromArray.h"
#include "MusicManager.h"
#include "SoundEffectManager.h"
#include "ExistFile.h"
#include "SdlUtils.h"

using namespace beego;


struct CommonResources::pImpl {
  SDL_Surface* scr;
  Layer debug_layer;
  Surface back_bmp_surface;     // !!! ێKv񂾂H ̂̎
  Surface back_surface;
  boost::shared_ptr<AnimationSurface> icon_surface;
  bool music_initialized;
  beego::MusicManager* music;              //!< wiȂ̊Ǘ
  beego::SoundEffectManager* sound_effect; //!< ʉ̊Ǘ

  pImpl(void)
  : scr(SDL_GetVideoSurface()), music_initialized(false),
    music(NULL), sound_effect(NULL) {
  }

  ~pImpl(void) {
    delete music;
    delete sound_effect;
  }
};


CommonResources::CommonResources(const char* savedir)
  : pimpl(new pImpl),
    gui(new GuiManager), front_layer(new Layer), back_layer(new Layer),
    recorder(new TypingRecorder),
    voice_(new VoicePlayer(VoiceDir)), savedir_(savedir),
    settings(new AccessSettings(savedir)) {

  gui->push_back(back_layer);
  gui->push_front(front_layer);
  gui->push_front(&pimpl->debug_layer);
}


CommonResources::~CommonResources(void) {

  // !!! ܂AĂ΂邱Ƃ͑z肵ĂȂ񂾂...
  // !!! ̂AK؂ȃ\bhɈړ
  delete input;
  delete font;
  delete back_layer;
  delete front_layer;
  delete gui;
}


CommonResources* CommonResources::getObject(const char* savedir) {
  static CommonResources obj(savedir);
  return &obj;
}


void CommonResources::initializeGui(void) {

  if (! pimpl->scr) {
    pimpl->scr = SDL_GetVideoSurface();
  }

  // wi摜̏
  Surface new_back_bmp_surface(new SdlSurface(createSurface(back_bmp,
                                                            back_bmp_width,
                                                            back_bmp_height)));
  std::swap(pimpl->back_bmp_surface, new_back_bmp_surface);

  Surface new_back_surface(new FillSurface(pimpl->back_bmp_surface,
                                           pimpl->scr->w, pimpl->scr->h));
  std::swap(pimpl->back_surface, new_back_surface);

  Component new_back_label(new LabelComponent(pimpl->back_surface));
  std::swap(back_label, new_back_label);

  // j[ACȐ
  boost::shared_ptr<AnimationSurface> new_icon_surface(new AnimationSurface);
  Surface cell_00(new SdlSurface(createSurface(selector_00_bmp,
                                               selector_00_bmp_width,
                                               selector_00_bmp_height), true));
  Surface cell_01(new SdlSurface(createSurface(selector_01_bmp,
                                               selector_01_bmp_width,
                                               selector_01_bmp_height), true));
  Surface cell_02(new SdlSurface(createSurface(selector_02_bmp,
                                               selector_02_bmp_width,
                                               selector_02_bmp_height), true));
  Surface cell_03(new SdlSurface(createSurface(selector_03_bmp,
                                               selector_03_bmp_width,
                                               selector_03_bmp_height), true));
  new_icon_surface->registerSurface(cell_00, 230, 0, 0);
  new_icon_surface->registerSurface(cell_01, 200, 8, 0);
  new_icon_surface->registerSurface(cell_02, 200, 8, 0);
  new_icon_surface->registerSurface(cell_03, 230, 0, 0);
  new_icon_surface->registerSurface(cell_02, 200, 8, 0);
  new_icon_surface->registerSurface(cell_01, 200, 8, 0);
  new_icon_surface->play();
  std::swap(pimpl->icon_surface, new_icon_surface);

  Component new_menu_icon(new LabelComponent(pimpl->icon_surface));
  std::swap(menu_icon, new_menu_icon);

  // ͎̏
  font = new TtfResource(FontPath);
  input = new InputHandler;

  boost::shared_ptr<InputReceiveComponent>
    new_input_receiver(new InputReceiveComponent);
  std::swap(input_receiver, new_input_receiver);

  // fobOpl̏
  TextProperty text_property(font, "", SmallSize, Black, Gray4, true);
  boost::shared_ptr<ConsolePanelComponent>
    panel(new ConsolePanelComponent(640, 480, text_property,
                                    ConsolePanelComponent::FadeOut,
                                    ConsolePanelComponent::Up));
  std::swap(debug, panel);

  // R|[lg̔zu
  pimpl->debug_layer.push_front(debug);
  back_layer->push_back(input_receiver);
}


bool CommonResources::accessFontData(void) {

  //std::string font_path;
  //std::vector<std::string> dir_path;
  //if (! searchFilePath(font_path, FontPath, dir_path)) {
  if (! existFile(FontPath)) {
    printf("\"%s\" is not found.\n", FontPath);
    return false;
  }
  return true;
}


bool CommonResources::accessMusicData(void) {

  //if (existFile(Music1_FilePath) && existFile(Music2_FilePath)) {
  if (existFile(MusicDirectory)) {
    return true;
  } else {
    return false;
  }
}


void CommonResources::initializeMusic(void) {

  if (! pimpl->music_initialized) {

    // IuWFNg̐錾
    pimpl->music = new MusicManager;
    if (! pimpl->music->isInitialized()) {
      delete pimpl->music;
      pimpl->music = NULL;
      return;
    }
    pimpl->sound_effect = new SoundEffectManager;

    // Đ
    pimpl->music->setFadeInEffect(PlayFadeIn);

    // y̏
    pimpl->music->registerMusic(BackMusic_1, Music1_FilePath);
    pimpl->music->registerMusic(BackMusic_2, Music2_FilePath);

    pimpl->sound_effect->registerEffect(SoundEffect_1, Effect1_FilePath);
    pimpl->sound_effect->registerEffect(SoundEffect_2, Effect2_FilePath);

#if 0
    pimpl->sound_effect->registerEffect(Decide, Decide_FilePath);
    pimpl->sound_effect->registerEffect(Type, Type_FilePath);
    pimpl->sound_effect->registerEffect(Miss, Miss_FilePath);
#else
    // y\[X hyakutypingrc.txt w\ɂ
    std::string dir_path = std::string(MusicDirectory);
    std::string decide_file = dir_path + settings->effect_decide_;
    std::string type_file = dir_path + settings->effect_type_;
    std::string miss_file = dir_path + settings->effect_miss_;

    pimpl->sound_effect->registerEffect(Decide, decide_file.c_str());
    pimpl->sound_effect->registerEffect(Type, type_file.c_str());
    pimpl->sound_effect->registerEffect(Miss, miss_file.c_str());
#endif

    // !!! ɁApImpl::user_index_ 錾H
    size_t user_index = settings->user_index_;
    int volume = settings->music_volume_[user_index];
    updateSoundVolume(volume);

    volume = settings->effect_volume_[user_index];
    updateEffectVolume(volume);

    pimpl->music_initialized = true;
  }
}


const char* CommonResources::getUserName(void) const {

  size_t user_index = settings->user_index_;
  return settings->user_names_[user_index].c_str();
}


void CommonResources::addUser(const char* user_name, const char* password) {

  int index = 0;
  for (std::vector<std::string>::iterator it = settings->user_names_.begin();
       it != settings->user_names_.end(); ++it, ++index) {
    if (! it->compare("")) {
      *it = user_name;
      settings->user_password_[index] = password;
      settings->user_index_ = index;

      break;
    }
  }
}


void CommonResources::deleteUser(int user_index) {
  settings->deleteUser(user_index);
}


void CommonResources::updateUserLable(void) {
  size_t user_index = settings->user_index_;
  const char* user_name = settings->user_names_[user_index].c_str();

  if (strlen(user_name) <= 0) {
    Surface new_user_surface(new NullSurface);
    Component new_user_label(new LabelComponent(new_user_surface));
    std::swap(user_label, new_user_label);
  } else {
    TextProperty user_property(font, user_name,
                               NormalSize, Fore, Back, true);
    Surface new_user_surface(new TextSurface(user_property));
    Component new_user_label(new LabelComponent(new_user_surface));
    std::swap(user_label, new_user_label);
  }

  SDL_Rect position;
  set_SdlRect(&position,
              rightPosition(user_label, 640) - TextOffset,
              TextOffset);
  user_label->setPosition(&position);
}


TypingTextConverter::ConvertType CommonResources::getConvertType(void) {

  size_t user_index = settings->user_index_;
  return (settings->convert_mode_[user_index] == 0) ?
    TypingTextConverter::Roman : TypingTextConverter::Kana;
}


int CommonResources::getPracticeNum(void) {

  size_t user_index = settings->user_index_;
  return settings->practice_num_[user_index];
}


int CommonResources::getPracticeNumIndex(void) {

  int index = 0;
  switch (getPracticeNum()) {
  case 10:
    index = 1;
    break;

  case 50:
    index = 2;
    break;

  case 100:
    index = 3;
    break;
  }

  return index;
}


void CommonResources::setPracticeNumIndex(size_t index) {

  int num_array[] = { 5, 10, 50, 100 };
  if (index >= sizeof(num_array)/sizeof(num_array[0])) {
    return;
  }

  size_t user_index = settings->user_index_;
  settings->practice_num_[user_index] = num_array[index];
}


void CommonResources::setNextMusic(int id) {
  if (pimpl->music) {
    pimpl->music->setNextMusic(id);
  }
}


bool CommonResources::nowSoundPlaying(void) {
  if (! pimpl->music) {
    return false;
  }

  return pimpl->music->nowPlaying();
}


void CommonResources::stopMusic(int fadeout_msec) {
  if (pimpl->music) {
    pimpl->music->stop(fadeout_msec);
  }
}


void CommonResources::haltMusic(void) {
  if (pimpl->music) {
    pimpl->music->halt();
  }
}


void CommonResources::updateSoundVolume(int percent) {
  if (pimpl->music) {
    pimpl->music->updateVolume(percent);
  }
}


void CommonResources::playEffect(int id) {
  if (pimpl->music) {
    pimpl->sound_effect->play(id);
  }
}


bool CommonResources::nowEffectPlaying(void) {
  if (! pimpl->music) {
    return false;
  }
  return pimpl->sound_effect->nowPlaying();
}


void CommonResources::stopEffect(void) {
  if (pimpl->music) {
    pimpl->sound_effect->stop();
  }
}


void CommonResources::updateEffectVolume(int percent) {
  if (pimpl->music) {
    pimpl->sound_effect->updateVolume(percent);
  }
}
