#ifndef WAKA_DRAWER_H
#define WAKA_DRAWER_H

/*!
  \file
  \brief â̕`

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TypingMode.h"
#include <SDL.h>
#include <memory>
#include <vector>


/*!
  \brief â̕`
*/
class WakaDrawer {
  WakaDrawer(void);
  WakaDrawer(const WakaDrawer& rhs);
  WakaDrawer& operator = (const WakaDrawer& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

 public:
  /*!
    \brief ^CsO[hw̃RXgN^

    \param mode [i] ^CsO[h
  */
  explicit WakaDrawer(TypingMode mode);
  ~WakaDrawer(void);

  /*!
    \brief `悷â̓o^

    \param index [i] `悷â̔ԍ
  */
  void setWakaIndex(size_t index);

  /*!
    \brief ͌̔zu

    \param text [i] ȕ\̓͌
    \param roman_sample [i] [}͌
  */
  void setInputSample(const std::vector<std::vector<Uint16> >& text,
                      const std::string& roman_sample);

  /*!
    \brief ͌̍XV

    \param text [i] ȕ\̓͌
    \param ku_index [i] ̋̉Ԗڂ܂œ͂
    \param roman_sample [i] [}͌
    \param need_bs [i] BackSpace L[𑣂ꍇ true
  */
  void updateInputSample(const std::vector<std::vector<Uint16> >& text,
                         size_t ku_index, const std::string& roman_sample,
                         bool need_bs);

  /*!
    \brief ĕ`
  */
  void draw(void);

  /*!
    \brief R|[lg̔zu
  */
  void placeComponents(void);

  /*!
    \brief R|[lg̍폜
  */
  void removeComponents(void);

  /*!
    \brief ̓R|[lg̍폜
  */
  void removeInputComponents(void);

  // !!! `ʒu̎w胁\bh́AKvɉĒǉ
};

#endif /*! WAKA_DRAWER_H */
