/*!
  \file
  \brief ^CsŐL^

  \author Satofumi KAMIMURA

  $Id$

  \todo ͊Jn̔fA͂ƂAɌł悤ɂ
*/

#include "TypingRecorder.h"
#include <ctype.h>


struct TypingRecorder::pImpl {
  GameSettings data_;
  size_t waka_num_;
  double start_delay_;
  double typing_speed_;
  size_t miss_types_;

  pImpl(void)
    : waka_num_(0), start_delay_(0.0), typing_speed_(0.0), miss_types_(0) {
  }

  void initData(void) {
    data_.rand_seed = 1;
    data_.mode = ShimonokuTyping;
    data_.waka.clear();
  }
};


TypingRecorder::TypingRecorder(void) : pimpl(new pImpl) {
}


TypingRecorder::~TypingRecorder(void) {
}


void TypingRecorder::recordGame(int rand_seed, TypingMode mode) {
  pimpl->initData();

  pimpl->data_.rand_seed = rand_seed;
  pimpl->data_.mode = mode;
}


void TypingRecorder::recordWaka(size_t no) {
  WakaTyping waka;
  waka.no = no;
  pimpl->data_.waka.push_back(waka);
}


void TypingRecorder::evaluate(void) {

  // â̐
  pimpl->waka_num_ = pimpl->data_.waka.size();

  // ^CvxA^CsOJnxA^CvǍvZ
  size_t types = 0;
  size_t spent = 0;
  size_t miss = 0;
  size_t delay = 0;
  for (std::vector<WakaTyping>::iterator it = pimpl->data_.waka.begin();
       it != pimpl->data_.waka.end(); ++it) {
    types += it->keys.size() - 5;
    spent += it->keys.back().ticks - it->keys[1].ticks;
    delay += it->keys[1].ticks;

    // !!! algorithm ̉gׂȂH
    for (std::vector<KeyTiming>::iterator key_it = it->keys.begin();
         key_it != it->keys.end(); ++key_it) {
      if ((key_it->ch == BackSpace) || (key_it->ch == Clear)) {
        ++miss;
      }
    }
    miss -= 5;                        // VXẽNA
  }

  // ^CsOx
  pimpl->typing_speed_ = 1.0 * types / (spent / 1000.0);

  // ^Cv
  pimpl->miss_types_ = miss;

  // ͊Jnx
  pimpl->start_delay_ = 1.0 * delay / pimpl->waka_num_ / 1000.0;

  //print();
}


size_t TypingRecorder::getWakaNum(void) {
  return pimpl->waka_num_;
}


double TypingRecorder::getStartDelay(void) {
  return pimpl->start_delay_;
}


double TypingRecorder::getTypingSpeed(void) {
  return pimpl->typing_speed_;
}


size_t TypingRecorder::getMissTypes(void) {
  return pimpl->miss_types_;
}


void TypingRecorder::recordTyping(char ch, size_t ticks) {

  if (pimpl->data_.waka.empty()) {
    return;
  }

  WakaTyping& last = pimpl->data_.waka.back();
  KeyTiming key_timing;
  key_timing.ch = ch;
  key_timing.ticks = ticks;
  last.keys.push_back(key_timing);
}


void TypingRecorder::to_s(void) {
  // !!!
}


void TypingRecorder::print(void) {

  fprintf(stderr, "rand_seed = %d\n", pimpl->data_.rand_seed);
  fprintf(stderr, "mode = %d\n", pimpl->data_.mode);

  for (std::vector<WakaTyping>::iterator it = pimpl->data_.waka.begin();
       it != pimpl->data_.waka.end(); ++it) {
    fprintf(stderr, "no = %d\n", it->no);

    for (std::vector<KeyTiming>::iterator key_it = it->keys.begin();
         key_it != it->keys.end(); ++key_it) {
      char ch = key_it->ch;
      if (isprint(ch)) {
        fprintf(stderr, "%c:%d, ", ch, key_it->ticks);
      } else {
        switch (ch) {
        case Clear:
          fprintf(stderr, "[clear]:%d, ", key_it->ticks);
          break;

        case BackSpace:
          fprintf(stderr, "[bs]:%d, ", key_it->ticks);
          break;

        case Return:
          fprintf(stderr, "[return]:%d, ", key_it->ticks);
          break;

        case Complete:
          fprintf(stderr, "[complete]:%d, ", key_it->ticks);
          break;
        }
      }
    }
    fprintf(stderr, "\n");
  }
}
