/*!
  \file
  \brief ʉ̊Ǘ

  \author Satofumi KAMIMURA

  $Id$

  \todo Iɂ́A Mix_ChannelFinished() 𖳌Ă
*/

#include "SoundEffectManager.h"
#include "MixerInit.h"
#include "LockGuard.h"
#include "ExistFile.h"
#include <SDL_mixer.h>
#include <string>
#include <vector>
#include <map>

using namespace beego;


struct SoundEffectManager::pImpl : private MixerInit {

  class EffectInfo {
  public:
    std::string file_path;
    Mix_Chunk* effect;

    EffectInfo(void) : file_path(""), effect(NULL) {
    }
  };

  bool initialized;
  SDL_mutex* mutex;
  typedef std::map<int,EffectInfo> EffectMap;
  EffectMap effect_map;
  static size_t play_id;
  std::vector<size_t> channel_id;

  pImpl(void) : initialized(false), mutex(SDL_CreateMutex()) {

    if (! isInitialized()) {
      return;
    }

    channel_id.resize(ChannelNum, InvalidId);
    Mix_ChannelFinished(channelDone);
    initialized = true;
  }

  ~pImpl(void) {
    if (! isInitialized()) {
      return;
    }
    Mix_HaltChannel(-1);
  }

  static pImpl* getObject(void) {
    static pImpl obj;
    return &obj;
  }

  static void freeMusResource(EffectMap& effect_maps, int effect_id,
                              bool erase = false) {
    EffectMap::iterator p = effect_maps.find(effect_id);
    if (p != effect_maps.end()) {
      if (p->second.effect) {
        Mix_FreeChunk(p->second.effect);
        p->second.effect = NULL;
      }
      if (erase) {
        effect_maps.erase(p);
      }
    }
  }

  static void channelDone(int channel) {
    static pImpl* obj = getObject();

    LockGuard guard(obj->mutex);
    obj->channel_id[channel] = InvalidId;
  }
};
size_t SoundEffectManager::pImpl::play_id = 1;


SoundEffectManager::SoundEffectManager(void) : pimpl(pImpl::getObject()) {
}


SoundEffectManager::~SoundEffectManager(void) {
}


bool SoundEffectManager::isInitialized(void) {
  return pimpl->initialized;
}


bool SoundEffectManager::registerEffect(int effect_id, const char* file_path) {
  if (! isInitialized()) {
    return false;
  }

  // t@C̑݃`FbN
  if (! existFile(file_path)) {
    return false;
  }

  // ̂̂Ɠ ID w肳ꂽꍇA\[X폜
  LockGuard guard(pimpl->mutex);
  pImpl::freeMusResource(pimpl->effect_map, effect_id);

  // ̂ꏊ̓o^ƃ[h
  pImpl::EffectInfo effect_info;
  effect_info.file_path = file_path;
  Mix_Chunk* effect = Mix_LoadWAV(file_path);
  if (! effect) {
    // !!! G[bZ[W̕\
    // !!! ǂ悤H
    return false;
  }
  effect_info.effect = effect;
  pimpl->effect_map[effect_id] = effect_info;

  return true;
}


void SoundEffectManager::unregisterEffect(int effect_id) {
  if (! isInitialized()) {
    return;
  }

  // !!!
  // !!! ̉
  // !!! nbVvf̍폜
}


void SoundEffectManager::updateVolume(size_t percent, int channel_id) {
  if (! isInitialized()) {
    return;
  }

  if (percent > 100) {
    percent = 100;
  } else if (percent < 0) {
    percent = 0;
  }
  Mix_Volume(channel_id, MIX_MAX_VOLUME * percent / 100);

  // !!!
  // !!! ʒB̂
}


int SoundEffectManager::play(int effect_id,
                        size_t fade_in_msec, int volume_percent) {
  if (! isInitialized()) {
    return InvalidId;
  }

  // !!! Ƃ肠AĐ
  pImpl::EffectMap::iterator it = pimpl->effect_map.find(effect_id);
  if (it == pimpl->effect_map.end()) {
    // !!!
    fprintf(stderr, "no soundd effect: %d\n", effect_id);
    return -1;
  }

  int id = Mix_PlayChannel(-1, it->second.effect, 0);
  if (id < 0) {
    return id;
  }

  LockGuard guard(pimpl->mutex);
  size_t playing_id = pimpl->channel_id[id] = pImpl::play_id;
  ++pImpl::play_id;

  return playing_id;
}


void SoundEffectManager::stop(int serial_id, size_t fade_out_msec) {
  if (! isInitialized()) {
    return;
  }

  Mix_FadeOutChannel(serial_id, fade_out_msec);
  // !!! ID pāǍʉĐł΁A~
  // !!! tF[hAEg̎w
  // !!! fade_out_msec ̒lɂẮAŃtF[hAEgsÂ\H
}


bool SoundEffectManager::nowPlaying(int serial_id) {
  if (! isInitialized()) {
    return false;
  }

  int channel_id = -1; // -1 ̂ƂAMix_Playing() ͂ǂꂩĐȂΐ^
  if (serial_id >= InvalidId) {

    LockGuard guard(pimpl->mutex);
    // !!! find ɂׂH
    for (size_t i = 0; i < MixerInit::ChannelNum; ++i) {
      if (pimpl->channel_id[i] == static_cast<size_t>(serial_id)) {
        channel_id = i;
        break;
      }
    }
  }
  return (Mix_Playing(channel_id) == 0) ? false : true;
}

#if 0
// !!! ~pImpl ł̒~҂ŖȂ
// !!! GuiManager ƈقȂAŊĂ邽x1
void SoundEffectManager::terminate(void) {
}
#endif


void SoundEffectManager::setEachVolume(size_t effect_id, size_t percent) {

  // !!!
  // !!! 
}
