/*!
  \file
  \brief [U폜

  \author Satofumi KAMIMURA

  $Id$
*/

#include "RemoveUser.h"
#include "RemoveUser_uni.h"
#include "CommonResources.h"
#include "SystemDefinition.h"
#include "DrawsDefinition.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputHandler.h"
#include "TextProperty.h"
#include "TextSurface.h"
#include "LabelComponent.h"
#include "BaseEntity.h"
#include "StateMachine.h"
#include "SdlUtils.h"
#include "Delay.h"

using namespace beego;


struct RemoveUser::pImpl {

  class Schedule : public BaseEntity {
    StateMachine<Schedule>* state_machine;
    bool is_terminated;

  public:
    Schedule(int id, CommonResources* common)
      : BaseEntity(id), is_terminated(false) {
      state_machine = new StateMachine<Schedule>(this);
      state_machine->setCurrentState(FirstState::getObject(common));
    }

    ~Schedule(void) {
      delete state_machine;
    }

    void update(void) {
      state_machine->update();
    }

    void changeState(State<Schedule>* new_state) {
      state_machine->changeState(new_state);
    }

    void setTerminate(void) {
      is_terminated = true;
    }

    bool isTerminated(void) {
      return is_terminated;
    }
  };

  class FirstState : public State<Schedule> {
    CommonResources* common;

    FirstState(CommonResources* common_obj) : common(common_obj) {
    }

  public:
    static FirstState* getObject(CommonResources* common) {
      static FirstState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {
      type->setTerminate();
    }

    void execute(Schedule* type) {
      type->changeState(HttpInputState::getObject(common));
    }

    void exit(Schedule* type) {
    }
  };

  class HttpInputState : public State<Schedule> {
    CommonResources* common;

    HttpInputState(CommonResources* common_obj)
      : common(common_obj) {
    }

  public:
    static HttpInputState* getObject(CommonResources* common) {
      static HttpInputState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {
      placeComponents();
    }

    void execute(Schedule* type) {

      // !!!
      // type->changeState(NameInputState::getObject(common));
    }

    void exit(Schedule* type) {
      removeComponents();
    }

    void placeComponents(void) {
      // !!!
    }

    void removeComponents(void) {
      // !!!
    }
  };

#if 0
  class FirstState : public State<Schedule> {
    CommonResources* common;

    FirstState(CommonResources* common_obj) : common(common_obj) {
    }

  public:
    static FirstState* getObject(CommonResources* common) {
      static FirstState obj(common);
      return &obj;
    }

    void enter(Schedule* type) {
    }

    void execute(Schedule* type) {
      // type->changeState(PrologueState::getObject(common));
    }

    void exit(Schedule* type) {
      // !!!
    }
  };
#endif
  CommonResources* common;
  Schedule scheduler;
  TextProperty title_property;
  Surface title_surface;
  Component title_label;
  TextProperty back_property;
  Surface back_surface;
  Component back_label;

  pImpl(void)
    : common(CommonResources::getObject()),
      scheduler(GameSchedulerId, common),
      title_property(common->font, RemoveUser_title,
                     MenuSize, Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)),
      back_property(common->font, RemoveUser_back_message,
                    NormalSize, Fore, Back, true),
      back_surface(new TextSurface(back_property)),
      back_label(new LabelComponent(back_surface)) {

    // ^Cgʒu
    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label, 640/2),
                topPosition(title_label, 0) + TextOffset * 3);
    title_label->setPosition(&position);

    // ߂邽߂̃bZ[Wʒu
    set_SdlRect(&position, rightPosition(back_label, 640) - TextOffset,
                bottomPosition(back_label, 480) - TextOffset);
    back_label->setPosition(&position);
  }

  void placeComponents(void) {
    common->front_layer->push_front(title_label);
    common->front_layer->push_front(back_label);
  }

  void removeComponents(void) {
    common->front_layer->remove(title_label);
    common->front_layer->remove(back_label);
  }
};


RemoveUser::RemoveUser(void) : pimpl(new pImpl) {
  pimpl->placeComponents();
}


RemoveUser::~RemoveUser(void) {
  pimpl->removeComponents();
}


void RemoveUser::run(void) {

  GuiManager* gui = pimpl->common->gui;
  InputHandler& input = *pimpl->common->input;
  bool quit = false;
  bool escape_pressed = false;
  while (quit == false) {

    // Ԃ̍XV
    pimpl->scheduler.update();

    // I
    quit |= pimpl->scheduler.isTerminated();
    gui->update();
    input.update_all();
    if (input.haveQuitEvent()) {
      pimpl->common->front_layer->disable();
      quit |= true;
    }
    escape_pressed |= input.isPressed(SDLK_ESCAPE);
    if (escape_pressed && input.isReleased(SDLK_ESCAPE)) {
      quit |= true;
    }
    delay(1);
  }
}
