#ifndef GRAPH_DRAWER_H
#define GRAPH_DRAWER_H

/*!
  \file
  \brief Ot̕`

  \author Satofumi KAMIMURA

  $Id$
*/

#include "TypingMode.h"
#include <memory>


class GraphDrawer {
  GraphDrawer(void);
  GraphDrawer(const GraphDrawer& rhs);
  GraphDrawer& operator = (const GraphDrawer& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  explicit GraphDrawer(TypingMode mode);
  ~GraphDrawer(void);

  void drawGraph(void);
  void placeComponents(void);
  void removeComponents(void);
  bool keyPressed(void);
};

#endif /* !GRAPH_DRAWER_H */
