/*!
  \file
  \brief Ot̕`

  \author Satofumi KAMIMURA

  $Id$

  \todo Ot̕\ڂ̓[UɋL^Ă
*/

#include "GraphDrawer.h"
#include "GraphDrawer_uni.h"
#include "CommonResources.h"
#include "DrawsDefinition.h"
#include "AccessRecordPC.h"
#include "GuiManager.h"
#include "Layer.h"
#include "InputReceiveComponent.h"
#include "InputEvent.h"
#include "TextSurface.h"
#include "TextProperty.h"
#include "LabelComponent.h"
#include "SdlUtils.h"

using namespace beego;


struct GraphDrawer::pImpl {
  TypingMode typing_mode;
  CommonResources* common;
  bool is_decided;
  InputEvent input_event;
  TextProperty title_property;
  Surface title_surface;
  Component title_label;

  pImpl(TypingMode mode)
    : typing_mode(mode), common(CommonResources::getObject()),
      is_decided(false),
      title_property(common->font, GraphDrawer_title,
                     MenuSize, Fore, Back, true),
      title_surface(new TextSurface(title_property)),
      title_label(new LabelComponent(title_surface)) {

    // R|[lg̐
    // !!!

    // R|[lg̈ʒuݒ
    SDL_Rect position;
    set_SdlRect(&position, centerPosition(title_label, 640/2), TextOffset);
    title_label->setPosition(&position);
  }

  void placeComponents(void) {

    // Otp̃R|[lgzu
    common->front_layer->push_front(title_label);
    // !!!

    is_decided = false;
    common->input_receiver->clear();
  }

  void removeComponents(void) {

    // OtpR|[lg̍폜
    common->front_layer->remove(title_label);
    // !!!

    common->input_receiver->clear();
  }
};


GraphDrawer::GraphDrawer(TypingMode mode) : pimpl(new pImpl(mode)) {
}


GraphDrawer::~GraphDrawer(void) {
}


void GraphDrawer::drawGraph(void) {

  // !!!
  // !!! Ot\

  placeComponents();
}


void GraphDrawer::placeComponents(void) {
  pimpl->placeComponents();
}


void GraphDrawer::removeComponents(void) {
  pimpl->removeComponents();
}


bool GraphDrawer::keyPressed(void) {

  pimpl->common->input_receiver->updateInputEvent(pimpl->input_event);
  pimpl->is_decided |= InputEvent::isReleased(pimpl->input_event, SDLK_RETURN);

  return pimpl->is_decided;
}
