#ifndef ACCESS_RECORD_INTERFACE_H
#define ACCESS_RECORD_INTERFACE_H

/*!
  \file
  \brief L^f[^̑C^[tF[X

  \author Satofumi KAMIMURA

  $Id$
*/

#include <time.h>
#include <string>
#include <vector>


/*!
  \brief L^ڂ̒`
*/
typedef struct {
  int waka_num;                 //!< â̓͐
  int miss_types;               //!< ^Cv~X̉ []
  int delay_msec;               //!< ͊Jnx [msec]
  int elapse_msec;              //!< oߎ [msec]
} recordData_t;


/*!
  \brief L^ڍׂ̒`
*/
typedef struct {
  time_t time;                  //!< L^ꂽ
  std::string name;             //!< [U

  recordData_t data;            //!< L^
} recordLine_t;


class AccessRecordInterface {
public:
  virtual ~AccessRecordInterface(void) {}

  virtual bool record(const recordLine_t& data) = 0;
  virtual bool load(std::vector<recordLine_t>& data, time_t from, time_t to,
                    size_t max_num) = 0;
};

#endif /* !ACCESS_RECORD_INTERFACE_H */
