/*
 * html2hdml/emoji.c
 *   processing i-mode emoji (http://www.nttdocomo.co.jp/i/tag/emoji/)
 *
 * Coprygight (C) 2000-2003 Dino Co.,Ltd.
 * http://www.dino.co.jp/
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define EMOJI_FILENAME "/x/emoji.txt"

char *default_emoji_table[] = {
    "",                                       /* (dummy) */
    "<img icon=44>",                          /*   1 ; 63647 */
    "<img icon=107>",                         /*   2 ; 63648 */
    "<img icon=95>",                          /*   3 ; 63649 */
    "<img icon=191>",                         /*   4 ; 63650 */
    "<img icon=16>",                          /*   5 ; 63651 */
    "<img icon=190>",                         /*   6 ; 63652 */
    "<img icon=305>",                         /*   7 ; 63653 */
    "<img icon=263>",                         /*   8 ; 63654 */
    "<img icon=192>",      /* "r",                        9 ; 63655 */
    "<img icon=193>",      /* "",                       10 ; 63656 */
    "<img icon=194>",      /* "oq",                       11 ; 63657 */
    "<img icon=195>",      /* "I",                         12 ; 63658 */
    "<img icon=196>",      /* "q",                       13 ; 63659 */
    "<img icon=197>",      /* "",                       14 ; 63660 */
    "<img icon=198>",      /* "V",                       15 ; 63661 */
    "<img icon=199>",      /* "嶍",                         16 ; 63662 */
    "<img icon=200>",      /* "ˎ",                       17 ; 63663 */
    "<img icon=201>",      /* "Rr",                       18 ; 63664 */
    "<img icon=202>",      /* "r",                       19 ; 63665 */
    "<img icon=203>",      /* "",                         20 ; 63666 */
    "<img icon=218>",      /* "X|[c",                     21 ; 63667 */
    "<img icon=1>",        /* "싅",                         22 ; 63668 */
    "<img icon=306>",      /* "St",                       23 ; 63669 */
    "<img icon=220>",      /* "ejX",                       24 ; 63670 */
    "<img icon=219>",      /* "TbJ[",                     25 ; 63671 */
    "<img icon=221>",      /* "XL[",                       26 ; 63672 */
    "<img icon=307>",      /* "oXPbg{[",             27 ; 63673 */
    "<img icon=222>",      /* "[^[X|[c",             28 ; 63674 */
    "<img icon=308>",      /* "|Pbgx",                 29 ; 63675 */
    "<img icon=172>",      /* "d",                         30 ; 63676 */
    "<img icon=172>",      /* "nS",                       31 ; 63677 */
    "<img icon=217>",      /* "V",                       32 ; 63678 */
    "<img icon=125>",      /* "ԁiZ_j",                 33 ; 63679 */
    "<img icon=125>",      /* "ԁiquj",                   34 ; 63680 */
    "<img icon=216>",      /* "oX",                         35 ; 63681 */
    "<img icon=169>",      /* "D",                           36 ; 63682 */
    "<img icon=168>",      /* "s@",                       37 ; 63683 */
    "<img icon=112>",      /* "",                           38 ; 63684 */
    "<img icon=106>",      /* "r",                         39 ; 63685 */
    "<img icon=129>",      /* "X֋",                       40 ; 63686 */
    "<img icon=26>",       /* "a@",                         41 ; 63687 */
    "<img icon=212>",      /* "s",                         42 ; 63688 */
    "<img icon=205>",      /* "`sl",                       43 ; 63689 */
    "<img icon=1>",        /* "ze",                       44 ; 63690 */
    "<img icon=206>",      /* "Rrj",                     45 ; 63691 */
    "<img icon=213>",      /* "K\\X^h",            46 ; 63692 */
    "<img icon=208>",      /* "ԏ",                       47 ; 63693 */
    "<img icon=99>",       /* "M",                         48 ; 63694 */
    "<img icon=207>",      /* "gC",                       49 ; 63695 */
    "<img icon=146>",      /* "Xg",                   50 ; 63696 */
    "<img icon=93>",       /* "iX",                       51 ; 63697 */
    "<img icon=121>",      /* "o[",                         52 ; 63698 */
    "<img icon=121>",      /* "r[",                       53 ; 63699 */
    "<img icon=240>",      /* "t@[Xgt[h",             54 ; 63700 */
    "<img icon=301>",      /* "ueBbN",                   55 ; 63701 */
    "<img icon=195>",      /* "e@",                       56 ; 63702 */
    "<img icon=289>",      /* "JIP",                     57 ; 63703 */
    "<img icon=226>",      /* "f",                         58 ; 63704 */
    "<img icon=70>",       /* "E΂ߏ",                     59 ; 63705 */
    "<img icon=223>",      /* "Vn",                       60 ; 63706 */
    "<img icon=291>",      /* "y",                         61 ; 63707 */
    "<img icon=309>",      /* "A[g",                       62 ; 63708 */
    "<img icon=197>",      /* "",                         63 ; 63709 */
    "<img icon=311>",      /* "Cxg",                     64 ; 63710 */
    "<img icon=106>",      /* "`Pbg",                     65 ; 63711 */
    "<img icon=86>",       /* "i",                         66 ; 63712 */
    "<img icon=145>",      /* "։",                         67 ; 63713 */
    "<img icon=94>",       /* "J",                       68 ; 63714 */
    "<img icon=83>",       /* "Jo",                       69 ; 63715 */
    "<img icon=97>",       /* "{",                           70 ; 63716 */
    "<img icon=113>",      /* "{",                       71 ; 63717 */
    "<img icon=144>",      /* "v[g",                   72 ; 63718 */
    "<img icon=239>",      /* "o[Xf[",                   73 ; 63719 */
    "<img icon=85>",       /* "db",                         74 ; 63720 */
    "<img icon=161>",      /* "gѓdb",                     75 ; 63721 */
    "<img icon=142>",      /* "",                         76 ; 63722 */
    "<img icon=288>",      /* "su",                         77 ; 63723 */
    "<img icon=309>",      /* "Q[",                       78 ; 63724 */
    "<img icon=300>",      /* "bc",                         79 ; 63725 */
    "<img icon=51>",       /* "n[g",                       80 ; 63726 */
    "<img icon=314>",      /* "Xy[h",                     81 ; 63727 */
    "<img icon=315>",      /* "_C",                       82 ; 63728 */
    "<img icon=316>",      /* "Nu",                       83 ; 63729 */
    "<img icon=317>",      /* "",                           84 ; 63730 */
    "<img icon=318>",      /* "",                           85 ; 63731 */
    "<img icon=281>",      /* "iO[j",                   86 ; 63732 */
    "<img icon=319>",      /* "i`Lj",                 87 ; 63733 */
    "<img icon=320>",      /* "ip[j",                   88 ; 63734 */
    "<img icon=43>",       /* "E΂߉",                     89 ; 63735 */
    "<img icon=42>",       /* "΂ߏ",                     90 ; 63736 */
    "<img icon=248>",      /* "",                           91 ; 63737 */
    "<img icon=124>",      /* "",                         92 ; 63738 */
    "<img icon=116>",      /* "ዾ",                         93 ; 63739 */
    "<img icon=178>",      /* "Ԉ֎q",                       94 ; 63740 */

/* f940 */						  
    "<img icon=321>",      /* "V",                         95 ; 63808 */
    "<img icon=322>",      /* "⌇",                   96 ; 63809 */
    "<img icon=323>",      /* "",                         97 ; 63810 */
    "<img icon=15>",       /* "O",                       98 ; 63811 */
    "<img icon=47>",       /* "",                         99 ; 63812 */
    "<img icon=134>",      /* "",                          100 ; 63813 */
    "<img icon=251>",      /* "L",                          101 ; 63814 */
    "<img icon=255>",      /* "][g",                    102 ; 63815 */
    "<img icon=191>",      /* "NX}X",                  103 ; 63816 */
    "<img icon=71>",       /* "΂߉",                    104 ; 63817 */

/* f972 */						  
    "<img icon=155>",      /* "phone to",                    105 ; 63858 */
    "<img icon=108>",      /* "mail to",                     106 ; 63859 */
    "<img icon=166>",      /* "fax to",                      107 ; 63860 */
    "<img icon=247>",      /* "i",                           108 ; 63861 */
    "<img icon=247>",      /* "(i)",                         109 ; 63862 */
    "<img icon=247>",      /* "[",                      110 ; 63863 */
    "<img icon=247>",      /* "hR",                  111 ; 63864 */
    "<img icon=247>",      /* "hR|Cg",              112 ; 63865 */
    "<img icon=247>",      /* "L",                        113 ; 63866 */
    "<img icon=299>",      /* "",                        114 ; 63867 */
    "<img icon=272>",      /* "ID",                          115 ; 63868 */
    "<img icon=274>",      /* "pX[h",                  116 ; 63869 */
    "<img icon=6>",        /* "L",                      117 ; 63870 */
/* f980 */
    "<img icon=324>",       /*"NA",                      118 ; 63872 */
    "<img icon=119>",       /*"T[`iׂj",            119 ; 63873 */
    "<img icon=303>",       /*"mdv",                      120 ; 63874 */
    "<img icon=214>",       /*"ʒu",                    121 ; 63875 */
    "<img icon=299>",       /*"t[_C",              122 ; 63876 */
    "<img icon=85>",        /*"V[v_C",            123 ; 63877 */
    "<img icon=4>",         /*"op",                      124 ; 63878 */
    "<img icon=180>",                        /* 125 ; 63879 */
    "<img icon=181>",                        /* 126 ; 63880 */
    "<img icon=182>",                        /* 127 ; 63881 */
    "<img icon=183>",                        /* 128 ; 63882 */
    "<img icon=184>",                        /* 129 ; 63883 */
    "<img icon=185>",                        /* 130 ; 63884 */
    "<img icon=186>",                        /* 131 ; 63885 */
    "<img icon=187>",                        /* 132 ; 63886 */
    "<img icon=188>",                        /* 133 ; 63887 */
    "<img icon=325>",                        /* 134 ; 63888 */

    "<img icon=326>",      /* "",                        135 ; 63920 */

    "<img icon=272>",      /* 136 ; 63889 */
    "<img icon=328>",      /* 137 ; 63890 */
    "<img icon=265>",      /* "",                        138 ; 63891 */
    "<img icon=266>",      /* "n[gin[gj",    139 ; 63892 */
    "<img icon=257>",      /* "[ij",          140 ; 63893 */
    "<img icon=258>",      /* "i{j",            141 ; 63894 */
    "<img icon=259>",      /* "`i_j",        142 ; 63895 */
    "<img icon=260>",      /* "₾`i߂j",      143 ; 63896 */
    "<img icon=327>",      /* "ӂӂ",                    144 ; 63897 */
    "<img icon=287>",      /* "Obhij",        145 ; 63898 */
    "<img icon=256>",      /* "",                    146 ; 63899 */
    "<img icon=224>",      /* "Cij",            147 ; 63900 */
    "<img icon=247>",      /* "킢",                    148 ; 63901 */
    "<img icon=273>",      /* "LX}[N",                  149 ; 63902 */
    "<img icon=267>",      /* "҂҂iVj",          150 ; 63903 */
    "<img icon=77>",       /*"Ђ߂",                    151 ; 63904 */
    "<img icon=258>",      /*"ނi{j",              152 ; 63905 */
    "<img icon=281>",      /*"p`",                      153 ; 63906 */
    "<img icon=268>",      /*"e",                        154 ; 63907 */
    "<img icon=15>",       /*"[h",                      155 ; 63908 */
    "<img icon=286>",      /*"obhij",        156 ; 63909 */
    "<img icon=261>",      /*"zzz",                         157 ; 63910 */
    "<img icon=2>",        /*"!",                           158 ; 63911 */
    "<img icon=3>",        /*"!?",                          159 ; 63912 */
    "<img icon=269>",      /*"!!",                          160 ; 63913 */
    "<img icon=329>",      /*"ǂiՌj",              161 ; 63914 */
    "<img icon=330>",      /*"iюU銾j",      162 ; 63915 */
    "<img icon=263>",      /*"[ij",              163 ; 63916 */
    "<img icon=282>",      /*"_bVio܁j",    164 ; 63917 */
    "<img icon=9>",        /*"[",                          165 ; 63918 */
    "<img icon=10>",       /*"[",                          166 ; 63919 */
};

char *emoji_table[167];

/* OGt@Cǂݍ: tH[}bǵA

Oȏ̋󔒕EGԍEPȏ̋󔒕Eϊ̕

Gԍ http://www.nttdocomo.co.jp/i/tag/emoji/ QƂ̂ƁB

 */
int set_emoji_table()
{
  int i;
  for (i = 0; i <= 166; i++) {
    emoji_table[i] = default_emoji_table[i];
  }

#ifndef MOD_HTML2HDML
  {
    FILE *fp;
    char *emoji_filename;

    emoji_filename = EMOJI_FILENAME;

    fp = fopen(emoji_filename, "r");
    if (fp) {
      char buf[2048];
      while (fgets(buf, 2048, fp)) {
	char *p;
	p = strchr(buf, '\0');
	while (buf < p) {
	  /* s̉sƂ菜 */
	  p--;
	  if (strchr("\r\n", *p) == NULL) break;
	  *p = '\0';
	}
	p = buf + strspn(buf, " \t\r\n"); /* s̋󔒕skip */

	if ((i = strspn(p, "0123456789")) != 0) {
	  long int j;
	  /* i͐ */
	  j = strtol(p, NULL, 10);
	  if (j > 0 && j <= 166) {
	    p += i;
	    if ((i = strspn(p, " \t\r\n")) != 0) {
	      /* i͋󔒕 */
	      p += i;
	      emoji_table[j] = strdup(p);
	    }
	  }
	}
      }
      fclose(fp);
    }
  }
#endif

  return 0;
}
