// html2hdml
// Coprygight (C) 2000-2003 Dino Co.,Ltd.
// http://www.dino.co.jp/
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "html2hdml.h"

enum list_type {
    enum_OL, enum_UL,
};
struct list_stack {
    enum list_type type;
    int index;
    struct list_stack *prev;
};

struct list_stack gl_list_dummy = {
    enum_UL,
    -1,
    NULL,
};
struct list_stack *gl_list_stack_top = &gl_list_dummy;

static int gl_list_level = 0;

struct list_stack *alloc_list_stack(enum list_type type,
				    struct list_stack *prev);
int free_list_stack(struct list_stack *node);
int convert_OL(char *stago, char *elemname, char **attr, char *tagc);
int convert_OL_(char *stago, char *elemname, char **attr, char *tagc);
int convert_UL(char *stago, char *elemname, char **attr, char *tagc);
int convert_UL_(char *stago, char *elemname, char **attr, char *tagc);

struct list_stack *alloc_list_stack(enum list_type type,
				    struct list_stack *prev) {
    struct list_stack *node;

    if (prev == NULL) return prev; /* not permited */

    node = (struct list_stack *)my_malloc(sizeof(struct list_stack));
    node->type = type;
    node->index = 1;
    node->prev = prev;
    
    return node;
}

int free_list_stack(struct list_stack *node) {
    if (node->prev == NULL) {
	/* this node is dummy */
    } else {
	my_free(node);
    }
    return 0;
}

int convert_OL(char *stago, char *elemname, char **attr, char *tagc)
{
    gl_list_stack_top = alloc_list_stack(enum_OL, gl_list_stack_top);
    return 0;
}

int convert_OL_(char *stago, char *elemname, char **attr, char *tagc)
{
    struct list_stack *prev;
    prev = gl_list_stack_top->prev;
    if (prev) {
      my_free(gl_list_stack_top);
      gl_list_stack_top = prev;
    }

//    add_piece(enum_current, "<BR>\n");
    return 0;
}

int convert_UL(char *stago, char *elemname, char **attr, char *tagc)
{
    gl_list_stack_top = alloc_list_stack(enum_UL, gl_list_stack_top);
    return 0;
}

int convert_UL_(char *stago, char *elemname, char **attr, char *tagc)
{
    struct list_stack *prev;
    prev = gl_list_stack_top->prev;
    if (prev) {
      my_free(gl_list_stack_top);
      gl_list_stack_top = prev;
    }

//    add_piece(enum_current, "<BR>\n");
    return 0;
}

int convert_LI(char *stago, char *elemname, char **attr, char *tagc) {
    int index;
    char buf[BUFFER_SIZE];

    index = gl_list_stack_top->index;

    if (gl_list_stack_top->prev == NULL ||
	gl_list_stack_top->type == enum_UL) {

	sprintf(buf, "<BR>\n* ");
    } else {
	sprintf(buf, "<BR>\n%d. ", index);
    }
    add_piece(enum_current, buf);

    gl_list_stack_top->index++;
    return 0;
}
