#include "test.h"
#include <stdarg.h>

BOOL
checkNoHeader(HTLIB_HANDLE h, HTLIB_Header* hh, int hlen,
			  const char* id, const char* name)
{
	HTLIB_ERROR err;
	int i;
	if ((i=HTLIB_Find(hh, hlen, name))!=-1) {
		FAIL(id, "why header=%s", name);
		return FALSE;
	}
	return TRUE;
}
BOOL
checkHeader(HTLIB_HANDLE h, HTLIB_Header* hh, int hlen,
			const char* id, const char* name, const char* value)
{
	HTLIB_ERROR err;
	int i;
	if ((i=HTLIB_Find(hh, hlen, name))==-1) {
		FAIL(id, "no header=%s", name);
		return FALSE;
	}
	if (strcmp(hh[i].value, value)!=0) {
		FAIL(id, "%s: %s must be %s", hh[i].name, hh[i].value, value);
		return FALSE;
	}
	return TRUE;
}
BOOL
checkNotHeader(HTLIB_HANDLE h, HTLIB_Header* hh, int hlen,
			   const char* id, const char* name, const char* value)
{
	HTLIB_ERROR err;
	int i;
	if ((i=HTLIB_Find(hh, hlen, name))==-1) {
		FAIL(id, "no header=%s", name);
		return FALSE;
	}
	if (strcmp(hh[i].value, value)==0) {
		FAIL(id, "%s: %s must be different", hh[i].name, hh[i].value);
		return FALSE;
	}
	return TRUE;
}


int
receiveBody(HTLIB_HANDLE h, char* body, int bsize, const char* id)
{
	HTLIB_ERROR err;
	int index = 0;
	int rest;
	int len;
	while ((rest = bsize-index)>0) {
		len = HTLIB_ReceiveBody(h, 2000,
								body + index, rest, &err);
		if (len == -1) {
			FAIL(id, "ReceiveBody len=%d", len);
			return -1;
		}
		index += len;
		if (len == 0) {
			printf("received %d bytes\n", index);
			return index;
		}
	}

	FAIL(id, "buffer Overflow index=%d", index);
	return -1;
}

BOOL
sendBodyChunk(HTLIB_HANDLE h, int timeout_millis, const void* body, int len,
			  HTLIB_ERROR* err)
{
	if (HTLIB_SendBody(h, timeout_millis, NULL, len, err)==FALSE) {
		return FALSE;
	}
	if (HTLIB_SendBody(h, timeout_millis, body, len, err)==FALSE) {
		return FALSE;
	}
	return TRUE;
}

void
fail(const char* id, const char* file, int line,
	HTLIB_ERROR err, int system_error,
	const char* format, ...)
{
	va_list ap;
	va_start(ap, format);

	char buf[256];
	vsnprintf(buf, sizeof(buf), format, ap);

	printf("%s:%d: FAIL: %s [err=%s errno=%d] %s\n",
		   file, line, id, 
		   HTLIB_GetErrorMessage(err), system_error, buf);

	va_end(ap);
}

void
succeed(const char* id, const char* file, int line)
{
	printf("%s:%d: SUCCEED: %s\n", file, line, id);
}
