#include "test.h"
#include "cpost.h"

#define HHMAX 30

static HTLIB_ERROR err;
static HTLIB_Header hh[HHMAX];
static HTLIB_USHORT hhlen;
static int status;

static const char* id = NULL;

static BOOL
chkNoHeader(HTLIB_HANDLE h, const char* name)
{
	return checkNoHeader(h, hh, hhlen, id, name);
}
static BOOL
chkHeader(HTLIB_HANDLE h, const char* name, const char* value)
{
	return checkHeader(h, hh, hhlen, id, name, value);
}
#if 0
static BOOL
chkNotHeader(HTLIB_HANDLE h, const char* name, const char* value)
{
	return checkNotHeader(h, hh, hhlen, id, name, value);
}
#endif
static char body[10000];

static int
recvBody(HTLIB_HANDLE h)
{
	return receiveBody(h, body, sizeof(body), id);
}

static void
test1(HTLIB_HANDLE h, const char* path)
{
	HTLIB_Header reqh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
	};
	if (HTLIB_SendRequest(h, -1, "POST", URLBASE "/post/200",
						  reqh, sizeof(reqh)/sizeof(reqh[0]),
						  "12345", 5, &err)==FALSE) {
		FAIL(id, "");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Length", "6")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=6) {
		FAIL(id, "%d must be 6", len);
		return;
	}
	if (memcmp(body, "postok", 6)!=0) {
		FAIL(id, "%.*s must be postok", 6, body);
		return;
	}
	SUCCEED(id);
}	
static void
test2(HTLIB_HANDLE h, const char* path)
{
	HTLIB_Header reqh[] = {
		{ "Content-Type", "application/octet-stream", 0, NULL },
	};
	if (HTLIB_SendRequest(h, -1, "POST", URLBASE "/post/404",
						  reqh, sizeof(reqh)/sizeof(reqh[0]),
						  "12\00045", 5, &err)==FALSE) {
		FAIL(id, "");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=404) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Length", "6")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=6) {
		FAIL(id, "%d must be 6", len);
		return;
	}
	if (memcmp(body, "postng", 6)!=0) {
		FAIL(id, "%.*s must be postok", 6, body);
		return;
	}
	SUCCEED(id);
}	

static void
test3(HTLIB_HANDLE h, const char* path)
{
	HTLIB_Header reqh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
	};
	if (HTLIB_SendRequest(h, -1, "POST", URLBASE "/post/chunk",
						  reqh, sizeof(reqh)/sizeof(reqh[0]),
						  NULL, -1, &err)==FALSE) {
		FAIL(id, "");
		return;
	}
	if (sendBodyChunk(h, -1, "12345", 5, &err)==FALSE) {
		FAIL(id, "sendBodyChunk");
		return;
	}
	if (sendBodyChunk(h, -1, "67890", 5, &err)==FALSE) {
		FAIL(id, "sendBodyChunk");
		return;
	}
	if (HTLIB_SendBody(h, -1, NULL, 0, &err)==FALSE) {
		FAIL(id, "sendBodyChunk NUL");
		return;
	}

	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Transfer-Encoding", "chunked")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Content-Length")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=10) {
		FAIL(id, "%d must be 10", len);
		return;
	}
	if (memcmp(body, "1234567890", 10)!=0) {
		FAIL(id, "%.*s must be 1234567890", 10, body);
		return;
	}
	SUCCEED(id);
}	
static void
test4(HTLIB_HANDLE h, const char* path)
{
	HTLIB_Header reqh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
	};
	if (HTLIB_SendRequest(h, -1, "POST", URLBASE "/post/endbyclose1",
						  reqh, sizeof(reqh)/sizeof(reqh[0]),
						  NULL, -1, &err)==FALSE) {
		FAIL(id, "");
		return;
	}
	if (sendBodyChunk(h, -1, "12345", 5, &err)==FALSE) {
		FAIL(id, "sendBodyChunk");
		return;
	}
	if (sendBodyChunk(h, -1, "67890", 5, &err)==FALSE) {
		FAIL(id, "sendBodyChunk");
		return;
	}
	if (HTLIB_SendBody(h, -1, NULL, 0, &err)==FALSE) {
		FAIL(id, "sendBodyChunk NUL");
		return;
	}

	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Transfer-Encoding")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Content-Length")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	if (chkHeader(h, "Connection", "close")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=10) {
		FAIL(id, "%d must be 10", len);
		return;
	}
	if (memcmp(body, "1234567890", len)!=0) {
		FAIL(id, "%.*s must be 1234567890", len, body);
		return;
	}
	SUCCEED(id);
}	

static void
test5(HTLIB_HANDLE h, const char* path)
{
	HTLIB_Header reqh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
		{ "Connection", "close", 0, NULL },
	};
	if (HTLIB_SendRequest(h, -1, "POST", URLBASE "/post/endbyclose2",
						  reqh, sizeof(reqh)/sizeof(reqh[0]),
						  NULL, -1, &err)==FALSE) {
		FAIL(id, "");
		return;
	}
	if (sendBodyChunk(h, -1, "12345", 5, &err)==FALSE) {
		FAIL(id, "sendBodyChunk");
		return;
	}
	if (sendBodyChunk(h, -1, "67890", 5, &err)==FALSE) {
		FAIL(id, "sendBodyChunk");
		return;
	}
	if (HTLIB_SendBody(h, -1, NULL, 0, &err)==FALSE) {
		FAIL(id, "sendBodyChunk NUL");
		return;
	}

	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Transfer-Encoding")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Content-Length")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}
	if (chkHeader(h, "Connection", "close")==FALSE) {
		return;
	}
	int len;
	if ((len=recvBody(h))!=10) {
		FAIL(id, "%d must be 10", len);
		return;
	}
	if (memcmp(body, "1234567890", len)!=0) {
		FAIL(id, "%.*s must be 1234567890", len, body);
		return;
	}
	SUCCEED(id);
}	



void
testPost(HTLIB_HANDLE h)
{
	static struct {
		const char* id;
		const char* path;
		void(*func)(HTLIB_HANDLE, const char* path);
	} ff[] = {
		{ "POST-1(C)", "/post/200", test1 },
		{ "POST-2(C)", "/post/404", test2 },
		{ "POST-3(C)", "/post/chunk", test3 },
		{ "POST-4(C)", "/post/endbyclose1", test4 },
		{ "POST-5(C)", "/post/endbyclose2", test5 },
	};
	int i;
	for (i=0; i<sizeof(ff)/sizeof(ff[0]); i++) {
		id = ff[i].id;
		printf("Test %s...\n", id);
		ff[i].func(h, ff[i].path);
	}
}

