using System;
using System.Collections.Generic;
using System.Text;
using KttK.HspDecompiler.Ax3ToAs.Data.Line;
using KttK.HspDecompiler.Ax3ToAs.Data.Token;
using KttK.HspDecompiler.Ax3ToAs.Data.Primitive;
using KttK.HspDecompiler.Ax3ToAs.Data;
namespace KttK.HspDecompiler.Ax3ToAs.Data.Analyzer
{

	partial class LogicalLineFactory
	{
		//O猩̂͂
		/// <summary>
		/// sTokenCollectionLogicalLine쐬
		/// </summary>
		/// <param defaultName="parser"></param>
		/// <returns></returns>
		internal static LogicalLine GetCodeToken(TokenCollection stream)
		{
			if (stream == null)
				return null;
			if (stream.Count == 0)
				return null;
			if (stream.NextIsEndOfStream)
				return null;
			LogicalLine line = null;
			try
			{
				if (stream.NextToken is IfStatementPrimitive) //if, elses
					return (LogicalLine)readIf(stream);
				if (stream.NextToken is McallFunctionPrimitive) //ons
					return (LogicalLine)readMcall(stream);
				if (stream.NextToken is OnEventFunctionPrimitive)
				{ //on###s
					if(stream.NextNextTokenIsGotoFunction)//goto/gosubȂȂ
						return (LogicalLine)readOnEvent(stream);
					else
						return (LogicalLine)readCommand(stream);
				}
				if (stream.NextToken is OnFunctionPrimitive) //ons
					return (LogicalLine)readOn(stream);
				if (stream.NextToken is FunctionPrimitive)//̑̊֐
					return (LogicalLine)readCommand(stream);
				if (stream.NextToken is VariablePrimitive)//s
					return (LogicalLine)readAssignment(stream);
			}
			//HspLogicalLineExceptioncatchB̂Ƃł͍sĂ͂ȂȂ
			catch (HspLogicalLineException e)
			{

				line = new UnknownLine(stream.Primitives);
				line.AddError(e.Message);
				return line;
			}
			line = new UnknownLine(stream.Primitives);
			line.AddError("HsF擪̒Pꂪ߂łȂ");
			return line;
		}

		private static LogicalLine readMcall(TokenCollection stream)
		{
			int start = stream.Position;
			McallFunctionPrimitive mcall = stream.GetNextToken() as McallFunctionPrimitive;
			if (mcall == null)
				throw new HspLogicalLineException("mcallFmcallv~eBuȊOX^[g");
			if (stream.NextIsEndOfLine)
			{
				stream.Position = start;
				return (LogicalLine)readCommand(stream);
			}
			ExpressionToken exp = CodeTokenFactory.ReadExpression(stream);
			if (exp.CanRpnConvert)//RPNϊłȂ畁ʂ̊֐ƂĈB
			{
				stream.Position = start;
				return (LogicalLine)readCommand(stream);
			}

			stream.Position = start;
			stream.GetNextToken();
			VariablePrimitive var = stream.GetNextToken() as VariablePrimitive;
			if (var == null)
				throw new HspLogicalLineException("mcallsFϊs\Ȍ`");
			if (stream.NextIsBracketStart)//mcall ̋L@͔zϐF߂Ȃ
				throw new HspLogicalLineException("mcallsFϊs\Ȍ`");
			if (stream.NextIsEndOfLine)
				throw new HspLogicalLineException("mcallsFϊs\Ȍ`");
			exp = CodeTokenFactory.ReadExpression(stream);
			if (stream.NextIsEndOfLine)
				return new McallStatement(mcall, var, exp, null);
			ArgumentToken arg = CodeTokenFactory.ReadArgument(stream);
			if (stream.NextIsEndOfLine)
				return new McallStatement(mcall, var, exp, arg);
			throw new HspLogicalLineException("mcallsF]ȃg[N");
		}

		private static OnStatement readOn(TokenCollection stream)
		{
			OnFunctionPrimitive token = stream.GetNextToken() as OnFunctionPrimitive;
			if (token == null)
				throw new HspLogicalLineException("onsFv~eBuȊOX^[g");
			//ȂƂ邩Ȃ(sG[)
			if (stream.NextIsEndOfLine)
				return new OnStatement(token,null, null);
			//ǂށBgoto/gosubȂƂ邩Ȃ(sG[)
			ExpressionToken exp = CodeTokenFactory.ReadExpression(stream);
			if (stream.NextIsEndOfLine)
				return new OnStatement(token, exp,null);
			//goto/gosub֐ǂށBgoto/gosubȊOłRpC͒ʂ(sG[)
			//̊֐ɂ()ȂB
			FunctionToken func = CodeTokenFactory.ReadFunction(stream, false);
			if (stream.NextIsEndOfLine)
				return new OnStatement(token, exp, func);
			//܂܂ĂG[ˁB
			throw new HspLogicalLineException("onsF]ȃg[N");

		}

		private static OnEventStatement readOnEvent(TokenCollection stream)
		{
			OnEventFunctionPrimitive token = stream.GetNextToken() as OnEventFunctionPrimitive;
			if (token == null)
				throw new HspLogicalLineException("onsFv~eBuȊOX^[g");
			//goto/gosubȂƂ邩Ȃ(sG[)
			if (stream.NextIsEndOfLine)
				return new OnEventStatement(token, null);
			//goto/gosub֐ǂށBgoto/gosubȊOłRpC͒ʂ(sG[)
			//̊֐ɂ()ȂB
			FunctionToken func = CodeTokenFactory.ReadFunction(stream, false);
			if (stream.NextIsEndOfLine)
				return new OnEventStatement(token, func);
			//܂܂ĂG[ˁB
			throw new HspLogicalLineException("onsF]ȃg[N");
		}

		/// <summary>
		/// s
		/// </summary>
		/// <param defaultName="primitives"></param>
		/// <returns></returns>
		private static Assignment readAssignment(TokenCollection stream)
		{
			//ϐǂށBssȂB
			VariableToken token = CodeTokenFactory.ReadVariable(stream);
			//ZqǂށBsȂsȂB
			if (stream.NextIsEndOfLine)
				throw new HspLogicalLineException("sFZqȂ");
			OperatorToken op = CodeTokenFactory.ReadOperator(stream);
			//ȂƂB"x++"Ƃ
			if (stream.NextIsEndOfLine)
				return new Assignment(token, op);
			else
			{
				//ǂށB܂肪oȂOK
				ArgumentToken arg = CodeTokenFactory.ReadArgument(stream);
				if (stream.NextIsEndOfLine)
					return new Assignment(token, op, arg);
			}
			throw new HspLogicalLineException("sF]ȃg[N");

		}

		/// <summary>
		/// If,elseXe[gg̊Jn
		/// </summary>
		/// <param defaultName="primitives"></param>
		/// <returns></returns>
		private static IfStatement readIf(TokenCollection stream)
		{
			IfStatementPrimitive token = stream.GetNextToken() as IfStatementPrimitive;
			if (token == null)
				throw new HspLogicalLineException("sFv~eBuȊOX^[g");

			//elseɂ͎ȂB
			if (stream.NextIsEndOfLine)
				return new IfStatement(token);
			else
			{
				//ǂށB܂肪oȂOK
				ArgumentToken arg = CodeTokenFactory.ReadArgument(stream);
				if (stream.NextIsEndOfLine)
					return new IfStatement(token, arg);
			}
			throw new HspLogicalLineException("sF]ȃg[N");
		}

		/// <summary>
		/// ߍs
		/// </summary>
		/// <param defaultName="primitives"></param>
		/// <returns></returns>
		private static Command readCommand(TokenCollection stream)
		{
			//ԂCodeTokenFactoryɔC
			//߂ɂ́i֐ƈājʂ͂Ȃ
			FunctionToken func = CodeTokenFactory.ReadFunction(stream, false);
			if (stream.NextIsEndOfLine)
				return new Command(func);
			throw new HspLogicalLineException("ߍsF]ȃg[N");
		}

	}
}
