using System;
using System.Collections.Generic;
using System.Text;
using KttK.HspDecompiler.Ax3ToAs.Data.Token;
using KttK.HspDecompiler.Ax3ToAs.Data.Primitive;
using KttK.HspDecompiler.Ax3ToAs.Data;
namespace KttK.HspDecompiler.Ax3ToAs.Data.Analyzer
{
	//CodeTokenFactoryLogicalLineFactorÿꕔłB
	//HH
partial class LogicalLineFactory
{
	private static class CodeTokenFactory
	{
		internal static ExpressionToken ReadExpression(TokenCollection stream)
		{
			if (stream.NextIsEndOfLine)
				throw new HspLogicalLineException("FǂݍݒɃX^bNɂȂ");
			ExpressionTermToken elem = null;
			List<ExpressionTermToken> elements = new List<ExpressionTermToken>();
			do//Œ̓p[^͂B
			{
				if (stream.NextIsBracketEnd)
					break;
				if (stream.NextToken is OperatorPrimitive)
					elem = (ExpressionTermToken)(ReadOperator(stream));
				else if (stream.NextToken is LiteralPrimitive)
					elem = (ExpressionTermToken)(ReadLiteral(stream));
				else if (stream.NextToken is FunctionPrimitive)
					elem = (ExpressionTermToken)(ReadFunction(stream, true));
				else if (stream.NextToken is VariablePrimitive)
					elem = (ExpressionTermToken)(ReadVariable(stream));
				else
					throw new HspLogicalLineException("FsK؂ȗvfo");
				elements.Add(elem);
			} while (!stream.NextIsEndOfParam);
			ExpressionToken ret = new ExpressionToken(elements);
			ret.RpnConvert();
			return ret;
		}

		private static object ReadLiteral(TokenCollection stream)
		{
			if (stream.NextIsEndOfLine)
				throw new HspLogicalLineException("eFǂݍݒɃX^bNɂȂ");
			//eveBuǂݍ
			LiteralPrimitive token = stream.GetNextToken() as LiteralPrimitive;
			if (token == null)
				throw new HspLogicalLineException("eFsK؂ȗvfo");
			return new LiteralToken(token);
		}

		internal static ArgumentToken ReadArgument(TokenCollection stream)
		{
			if (stream.NextIsEndOfLine)
				throw new HspLogicalLineException("FǂݍݒɃX^bNɂȂ");
			bool hasBracket = stream.NextIsBracketStart;
			//ʓǂݎ̂āB
			if (hasBracket)
				stream.GetNextToken();
			List<ExpressionToken> exps = new List<ExpressionToken>();
			bool firstArgIsNull = stream.NextIsEndOfParam;
			//xǂݎn߂s')'܂œǂ݂
			while (!stream.NextIsEndOfLine)
			{
				if (hasBracket & stream.NextIsBracketEnd)
				{
					//ʓǂݎ̂ & I
					stream.GetNextToken();
					break;
				}
				exps.Add(ReadExpression(stream));
			}
			return new ArgumentToken(exps, hasBracket, firstArgIsNull);
		}

		internal static FunctionToken ReadFunction(TokenCollection stream, bool hasBracket)
		{
			if (stream.NextIsEndOfStream)
				throw new HspLogicalLineException("֐FǂݍݒɃX^bNɂȂ");
			FunctionPrimitive token = stream.GetNextToken() as FunctionPrimitive;
			if (token == null)
				throw new HspLogicalLineException("֐F֐v~eBuȊOX^[g");
			//sȂ狭IɏI
			if (stream.NextIsEndOfLine)
				return new FunctionToken(token);
			//S[Xgx
			if (token.HasGhostLabel	&& (stream.NextToken.CodeType == HspCodeType.Label))
			{
				stream.GetNextToken();
				if (stream.NextIsEndOfLine)
					return new FunctionToken(token);
			}

			//'('Ȃǂݍ
			if (stream.NextIsBracketStart)
				return new FunctionToken(token, ReadArgument(stream));
			//ǂłȂȂAhasBracketŕ
			//hasBracket@=falseȂ狭IɈɁB
			if (hasBracket)
				return new FunctionToken(token);
			else
				return new FunctionToken(token, ReadArgument(stream));
		}

		internal static VariableToken ReadVariable(TokenCollection stream)
		{
			if (stream.NextIsEndOfStream)
				throw new HspLogicalLineException("ϐFǂݍݒɃX^bNɂȂ");
			//ϐveBuǂݍ
			VariablePrimitive token = stream.GetNextToken() as VariablePrimitive;
			if (token == null)
				throw new HspLogicalLineException("ϐFϐv~eBuȊOX^[g");

			//ʂȂΔzϐ
			if (stream.NextIsBracketStart){
				return new VariableToken(token, ReadArgument(stream));
			}
			//łȂΕʂ̕ϐ
			return new VariableToken(token);
			//if (parser.NextIsEndOfLine)
			//    return VariableToken(token);
		}

		internal static OperatorToken ReadOperator(TokenCollection stream)
		{
			if (stream.NextIsEndOfLine)
				throw new HspLogicalLineException("ZqFǂݍݒɃX^bNɂȂ");
			//ϐveBuǂݍ
			OperatorPrimitive token = stream.GetNextToken() as OperatorPrimitive;
			if (token == null)
				throw new HspLogicalLineException("ZqFsK؂ȗvfo");
			return new OperatorToken(token);

		}
	}
}

}
