
#ifndef _SYNTAXTREE_H_
#define _SYNTAXTREE_H_

#include "sysDep.h"
#include "HArray.h"
#include "PtrArray.h"
#include "Substr.h"


#define _AT_USERACTION_DECL
#include "userActionFuncDef.h"
#undef _AT_USERACTION_DECL


namespace Houken {
    class Parser;
    class InputBuffer;
    class SyntaxTree {

    public:
#define _IN_SYNTAXTREE_DECL
#include "userActionFuncDef.h"
#undef _IN_SYNTAXTREE_DECL


    public:
        enum Valid_e {
            V_VALID,     // childs is valid
            V_INVALID,   // childs is not valid
            V_ERRORCUT,  // ErrorCut, errorCutId is valid
            V_FAIL,      // parse failed
            V_ERROR,     // parse error, errorCutId is valid
            V_FATAL_ERROR, // fatal error
        };
    public:
        static void* operator new(size_t);
        static void operator delete(void*);

        SyntaxTree(Valid_e v = V_INVALID);
        SyntaxTree(Parser* p, u32 startPos, u32 endPos, PtrArray<SyntaxTree>* ch = NULL);
        SyntaxTree(Parser* p, Substr& ss, PtrArray<SyntaxTree>* ch = NULL);
        SyntaxTree(Parser* p, Substr& ss, int errId); // create Error Cut
        SyntaxTree(u32 errPos, int errId, Parser* p); // create Error
        virtual ~SyntaxTree();

        int             numChild(void) { return (childs != NULL) ? childs->size() : 0; }
        SyntaxTree*     get(int idx) { return childs->get(idx); }
        SyntaxTree*     extract(int idx) { return childs->extract(idx); }
        SyntaxTree*     erase(int idx);         // delete child[idx]
        SyntaxTree*     shrink(void);           // pack all NULL gap
        void    deleteAllChild(void);

        // is childs valid ?
        bool            isValidTree(void) { return _valid == V_VALID; }
        bool            isFail(void) { return (_valid == V_FAIL) || isError(); }
        bool            isFailNotError(void) { return _valid == V_FAIL; }
        bool            isError(void) { return (_valid == V_ERROR) || (_valid == V_FATAL_ERROR); }
        bool            isFatalError(void) { return _valid == V_FATAL_ERROR; }
        bool            isErrorCut(void) { return _valid == V_ERRORCUT; }

        static void     finalize(void);

        // delete all childs recursively, and then delete itself
        static void     deleteRecursively(SyntaxTree* p);

    public:
        Substr          str;
        Parser*         parser;
        union {
            PtrArray<SyntaxTree>*   childs;
            int         errorCutId;
        };
        int             chooseNum;    // set by ordered choice

    protected:
        Valid_e         _valid;

    protected:
        static PtrArray<HArray<SyntaxTree> > _memPool;
        
    };


    extern SyntaxTree* const _PARSE_FAILED;   // parse result failed
    extern SyntaxTree* const _NO_SYNTAX_TREE; // tree disposed
    extern SyntaxTree* const _FATAL_PARSER_ERROR; // left recursion or something
    extern SyntaxTree* const _NOT_PARSED_YET; // Memoize; not parsed yet
    extern SyntaxTree* const _PARSING;        // Memoize; now parsing
    
}

#endif /* _SYNTAXTREE_H_ */
