
#include "SyntaxTree.h"
#include "Parser.h"
#include "InputBuffer.h"

// #include <stdio.h>

using namespace Houken;


static SyntaxTree st__PARSE_FAILED(SyntaxTree::V_FAIL);
static SyntaxTree st__NO_SYNTAX_TREE(SyntaxTree::V_INVALID);
static SyntaxTree st__FATAL_PARSER_ERROR(SyntaxTree::V_FATAL_ERROR);
static SyntaxTree st__NOT_PARSED_YET(SyntaxTree::V_INVALID);
static SyntaxTree st__PARSING(SyntaxTree::V_INVALID);

SyntaxTree* const Houken::_PARSE_FAILED = &st__PARSE_FAILED;
SyntaxTree* const Houken::_NO_SYNTAX_TREE = &st__NO_SYNTAX_TREE;
SyntaxTree* const Houken::_FATAL_PARSER_ERROR = &st__FATAL_PARSER_ERROR;
SyntaxTree* const Houken::_NOT_PARSED_YET = &st__NOT_PARSED_YET;
SyntaxTree* const Houken::_PARSING = &st__PARSING;


PtrArray<HArray<SyntaxTree> > SyntaxTree::_memPool(0);


SyntaxTree::SyntaxTree(Valid_e v)
    : str(0,0), parser(NULL), errorCutId(0),
      chooseNum(-1), _valid(v)
{
    // sys_printf("new null\n");
}

SyntaxTree::SyntaxTree(Parser* p, u32 startPos, u32 endPos, PtrArray<SyntaxTree>* ch)
    : str(startPos, endPos), parser(p), childs(ch),
      chooseNum(-1), _valid(V_VALID)
{
    // sys_printf("new(%x) st=%d\n",this,startPos);
}

SyntaxTree::SyntaxTree(Parser* p, Substr& ss, PtrArray<SyntaxTree>* ch)
    : str(ss), parser(p), childs(ch),
      chooseNum(-1), _valid(V_VALID)
{
    // sys_printf("new(%x) st=%d\n",this,ss.startPos);
}

SyntaxTree::SyntaxTree(Parser* p, Substr& ss, int errId)
    : str(ss), parser(p), errorCutId(errId),
      chooseNum(-1), _valid(V_ERRORCUT)
{
}

SyntaxTree::SyntaxTree(u32 errPos, int errId, Parser* parser)
    : str(errPos, errPos), parser(parser), errorCutId(errId),
      chooseNum(-1), _valid(V_ERROR)
{
}

SyntaxTree::~SyntaxTree()
{
    // SyntaxTree::finalize() ꊇ폜B
    // ʂłdeleteȂB
    // SyntaxTree::finalize()  ~SyntaxTree() Ă΂ȂB
}

void* SyntaxTree::operator new(size_t size)
{
    sys_assert(size == sizeof(SyntaxTree));
    HArray<SyntaxTree>* p;
    if (_memPool.size() < 1) {
        p = new HArray<SyntaxTree>(100);
        _memPool.add(p);
    } else {
        p = _memPool.get(_memPool.size() - 1);
        if (p->remain() < 1) {
            p = new HArray<SyntaxTree>(p->size() + 100);
            _memPool.add(p);
        }
    }
    return (void*) p->keep();
}

void SyntaxTree::operator delete(void* p)
{
    // delete all by finalize()
}

void SyntaxTree::finalize(void)
{
    // ~SyntaxTree() Ă΂ȂB
    PtrArrayIterator<HArray<SyntaxTree> > itr(&_memPool);
    while (itr.hasMore()) {
        delete itr.next();
    }
    _memPool.clean();
}

SyntaxTree* SyntaxTree::erase(int idx)
{
    sys_assert(isValidTree());
    sys_assert(childs != NULL);
    sys_assert(idx < childs->size());
    SyntaxTree* st = childs->extract(idx);
    if (st->isValidTree()) {
        delete st;
    }
    return this;
}

SyntaxTree* SyntaxTree::shrink(void)
{
    sys_assert(isValidTree());
    if (childs != NULL)
        childs->shrink();
    return this;
}

void SyntaxTree::deleteAllChild(void)
{
    sys_assert(isValidTree());
    if (childs == NULL)
        return;

    PtrArrayIterator<SyntaxTree> itr(childs);
    while (itr.hasMore()) {
        SyntaxTree* st = itr.next();
        if (st != NULL)
            delete st;
    }
    delete childs;
    childs = NULL;
}

void SyntaxTree::deleteRecursively(SyntaxTree* p)
{
    if (p == NULL)
        return;
    if (! p->isValidTree())
        return;
    if (p->childs != NULL) {
        PtrArrayIterator<SyntaxTree> itr(p->childs);
        while (itr.hasMore()) {
            SyntaxTree* st = itr.next();
            if (st != NULL)
                deleteRecursively(st);
        }
        delete p->childs;
    }
    delete p;
}
