
#include "SourceInfo.h"
#include <stdio.h>

using namespace Houken;


void* SourceInfo::operator new(size_t size)
{
    return sys_alloc((u32)size);
}

void SourceInfo::operator delete(void* p)
{
    if (p != NULL)
        sys_free(p);
}

SourceInfo::SourceInfo(void)
    : line(0), col(0), fname(NULL)
{
}

void SourceInfo::printns(char* dest, u32 destSize)
{
    if (fname == NULL)
        sys_snprintf(dest, destSize, "line=%d,col=%d", line, col);
    else
        sys_snprintf(dest, destSize, "%s:%d:%d", fname, line, col);
#if 0
    if (fname == NULL)
        sys_snprintf(dest, destSize, "line=%d,col=%d", line, col);
    else
        sys_snprintf(dest, destSize, "file=%s,line=%d,col=%d", fname, line, col);
#endif
}
