
#include "ParserHolder.h"
#include "Parser.h"
#include "sysDep.h"
#include <stdio.h>

using namespace Houken;

ParserHolder::ParserHolder(int maxParser)
{
    _maxParser = maxParser;
    _numParser = 0;
    _parsers = sys_allocT<Parser*>(maxParser);
}

ParserHolder::~ParserHolder()
{
#if 0
    printf("_numParser was %d\n", _numParser);
#endif
    for (int i = _numParser - 1; i >= 0; --i)
        delete _parsers[i];
    sys_free(_parsers);
}


ParserID_t ParserHolder::entry(Parser* parser)
{
    sys_assert(_numParser < _maxParser);
    _parsers[_numParser] = parser;
    return (ParserID_t) _numParser++;
}

Parser* ParserHolder::get(ParserID_t id)
{
    sys_assert(id < _numParser);
    return _parsers[id];
}
