
#include "Operator.h"
#include "Parser.h"
#include <stdio.h>


using namespace Houken;


Operator::Operator(void) : _expIdents(1), _precs(1)
{
}

Operator::~Operator()
{
    PtrArrayIterator<HArray<u32> > it(&_precs);
    while (it.hasMore())
        delete it.extract_next();
}


bool Operator::entry(Substr& sIdent, u32 prec)
{
    if (prec <= 0) {
        fprintf(stderr, "ERROR: operator precedence must > 0\n");
        return false;
    }
    HArray<u32>* precArr;
    int i = _getIdx(sIdent);
    if (i < 0) {
        _expIdents.add(sIdent);
        precArr = new HArray<u32>(4);
        _precs.add(precArr);
    } else {
        precArr = _precs.get(i);
    }

    int precsSize = precArr->size();
    for (i = 0; i < precsSize; ++i) {
        if (precArr->get(i) == prec){
            char n[256];
            gpInp->copyStr(n, 256, sIdent);
            fprintf(stderr, "ERROR: duplicate operator definition\n");
            fprintf(stderr, "   rule = %s, prec = %d\n",n, prec);
            return false;
        }
    }
    precArr->add(prec);
    return true;
}

void Operator::sort(void)
{
    int opSize = _expIdents.size();
    for (int i = 0; i < opSize; ++i) {
        HArray<u32>* precArr = _precs.get(i);
        int precsSize = precArr->size();
        for (int j = 0; j < precsSize - 1; ++j) {
            u32 p = precArr->get(j);
            u32 pm = p;
            int x = j;
            for (int k = j+1; k < precsSize; ++k) {
                u32 p2 = precArr->get(k);
                if (p2 < pm) {
                    x = k;
                    pm = p2;
                }
            }
            if (x > j) {
                precArr->set(j, pm);
                precArr->set(x, p);
            }
        }
    }
}

u32 Operator::getHigher(Substr& sIdent, u32 prec)
{
    HArray<u32>* precArr = getPrecs(sIdent);
    sys_assert(precArr != NULL);
    int precsSize = precArr->size();
    for (int i = 0; i < precsSize; ++i) {
        if (precArr->get(i) == prec){
            if (i == precsSize-1)
                return 0;
            return precArr->get(i+1);
        }
    }
    sys_assert(false);
    return 0;
}

bool Operator::isOperand(Substr& sIdent)
{
    return (_getIdx(sIdent) >= 0);
}

HArray<u32>* Operator::getPrecs(Substr sIdent)
{
    int idx = _getIdx(sIdent);
    if (idx >= 0)
        return _precs.get(idx);
    return NULL;
}

int Operator::_getIdx(Substr sIdent)
{
    int opSize = _expIdents.size();
    for (int i = 0; i < opSize; ++i) {
        Substr s = _expIdents.get(i);
        if (gpInp->cmpStr(sIdent, s))
            return i;
    }
    return -1;
}
