
#include "sysDep.h"

#include <string.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <stdarg.h>

u32 sys_fileSize(const char* filename)
{
    struct stat statBuf;
    if (stat(filename, &statBuf) != 0)
        return 0;
    return (u32) statBuf.st_size;
}

u32 sys_readFile(char* buf, const char* filename, u32 size)
{
    FILE* fp = sys_fopen(filename, "rb");
    if (fp == NULL) {
        *buf = '\0';
        return 0;
    }

    size_t len = fread(buf, 1, (size_t)size, fp);
    fclose(fp);
    return (u32)len;
}

void* sys_alloc(u32 size)
{
     return calloc(size, 1);
}

void* sys_realloc(void* ptr, u32 size)
{
    return realloc(ptr, size);
}

void sys_free(void* addr)
{
    free(addr);
}

void sys_printf(const char* fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vprintf_s(fmt, ap);
    va_end(ap);
}

void sys_snprintf(char* buf, u32 bufsize, const char* fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vsprintf_s(buf, bufsize, fmt, ap);
    va_end(ap);
}

u32 sys_strlen(const char* p)
{
    return (u32)strlen(p);
}

void sys_strncpy(char* dest, const char* src, u32 size)
{
    strncpy_s(dest, (size_t)size, src, _TRUNCATE);
}

void sys_strncat(char* dest, const char* src, u32 size)
{
    strcat_s(dest, (size_t)size + sys_strlen(dest), src);
}

int sys_strcasecmp(const char* s1, const char* s2)
{
    return _strnicmp(s1, s2, strlen(s1)+1);
}


FILE* sys_fopen(const char* fname, const char* mode)
{
    FILE* fp;
    fopen_s(&fp, fname, mode);
    return fp;
}
