
#ifndef _SYSDEP_H_
#define _SYSDEP_H_


#include "wchar.h"
#include <string.h>
#include <stdio.h>

#ifdef __CYGWIN__
#undef WEOF
#define WEOF ((wchar_t)-1)
#endif


typedef char            s8;
typedef short           s16;
typedef int             s32;
typedef unsigned char   u8;
typedef unsigned short  u16;
typedef unsigned int    u32;
typedef float           f32;
typedef double          f64;


u32 sys_fileSize(const char* filename);
u32 sys_readFile(char* buf, const char* filename, u32 size);
void* sys_alloc(u32 size);
void* sys_realloc(void* ptr, u32 size);
void sys_free(void* addr);
void sys_printf(const char* fmt, ...);
void sys_snprintf(char* buf, u32 bufsize, const char* fmt, ...);
inline u32 sys_strlen(const char* p) { return strlen(p); }
inline void sys_strncpy(char* dest, const char* src, u32 size) { strncpy(dest, src, size); }
inline void sys_strncat(char* dest, const char* src, u32 size) { strncat(dest, src, size); }
inline int sys_strcasecmp(const char* s1, const char* s2) { return strcasecmp(s1, s2); }
inline FILE* sys_fopen(const char* fname, const char* mode) { return fopen(fname, mode); }
#define sys_assert(cond) if(!(cond)) \
        sys_printf("assertion \"" #cond "\" failed: file %s, line %d\n", __FILE__, __LINE__)


template <typename T> T* sys_allocT(u32 nmemb) { return (T*)sys_alloc(nmemb * sizeof(T)); }
template <typename T> T* sys_reallocT(T* ptr, u32 nmemb) { return (T*)sys_realloc((void*)ptr, nmemb * sizeof(T)); }


#endif /* _SYSDEP_H_ */
