
#include "sysDep.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>

u32 sys_fileSize(const char* filename)
{
    struct stat statBuf;
    if (stat(filename, &statBuf) != 0)
        return 0;
    return (u32) statBuf.st_size;
}

u32 sys_readFile(char* buf, const char* filename, u32 size)
{
    FILE* fp = sys_fopen(filename, "r");
    if (fp == NULL) {
        *buf = '\0';
        return 0;
    }

    size_t len = fread(buf, 1, (size_t)size, fp);
    fclose(fp);
    return (u32)len;
}

void* sys_alloc(u32 size)
{
     return calloc(size, 1);
}

void* sys_realloc(void* ptr, u32 size)
{
    return realloc(ptr, size);
}

void sys_free(void* addr)
{
    free(addr);
}

void sys_printf(const char* fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vprintf(fmt, ap);
    va_end(ap);
}

void sys_snprintf(char* buf, u32 bufsize, const char* fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vsnprintf(buf, bufsize, fmt, ap);
    va_end(ap);
}
