
#include "PegParser.h"

//============================================================
//@ Number		<% %[0-9]+
SyntaxTree* P_Number::uParse(void)
{
    _ErrorPos startPos = _curErrPos();
    if (gpInp->skip_decimalNum()) {
        return createSyntaxTree(startPos.parsePos);
    }
    _fail(startPos);
    return _PARSE_FAILED;
}

//============================================================
//@ Ident		<% %Ident1 %Ident2*
//@ #Ident1		<% %[a-z] / %[A-Z] / %"_"
//@ #Ident2		<% %Ident1 / %[0-9]
SyntaxTree* P_Ident::uParse(void)
{
    _ErrorPos startPos = _curErrPos();
    if (gpInp->skip_ident()) {
        return createSyntaxTree(startPos.parsePos);
    }
    _fail(startPos);
    return _PARSE_FAILED;
}

//============================================================
//@ NotTokenPred	<% !Ident2
SyntaxTree* P_NotTokenPred::uParse(void)
{
    wchar_t c = gpInp->getChar();
    gpInp->ungetChar();
    if (c >= L'a' && c <= L'z')
        return _PARSE_FAILED;
    if (c >= L'0' && c <= L'9')
        return _PARSE_FAILED;
    if (c >= L'A' && c <= L'Z')
        return _PARSE_FAILED;
    if (c == L'_')
        return _PARSE_FAILED;
    return _NO_SYNTAX_TREE;
}

//============================================================
//@ Comment		<% %"#" %XCharA* %("\n" / "\r")+
SyntaxTree* P_Comment::uParse(void)
{
    _ErrorPos startPos = _curErrPos();
    wchar_t c = gpInp->getChar();
    if (c == L'#') {
        gpInp->skip_beforeEol();
        gpInp->skip_eols();
        return createSyntaxTree(startPos.parsePos);
    }
    _fail(startPos);
    return _PARSE_FAILED;
}
