
#include "printSyntaxTree.h"
#include <stdio.h>
#include <string.h>

using namespace Houken;

void printSyntaxTree(SyntaxTree* tree, InputBuffer* inp, int indent)
{
    char is[128];
    char buf[128];
    if (tree == NULL) {
        printf("(NULL)\n");
        return;
    }

    if (indent > 60) indent = 60;
    for (int i = indent; --i >= 0;) is[i] = ' ';
    is[indent] = '\0';
    u32 len = tree->str.len();
    if ((int)len > 76 - indent)
        len = 76 - indent;
    inp->copySummary(buf, len+1, tree->str);
    if (tree->isErrorCut())
        printf("{ErrorCut %d}[%s]", tree->errorCutId, buf);
    else if (tree->isFatalError())
        printf("{FatalError}");
    else if (tree->isError())
        printf("{Error %d}", tree->errorCutId);
    else if (tree->isFail())
        printf("{Fail}");
    else if (! tree->isValidTree())
        printf("{Invalid}");
    else if (tree->chooseNum >= 0)
        printf("%s%s(%d)[%s]", is, tree->parser->name(), tree->chooseNum, buf);
    else
        printf("%s%s[%s]", is, tree->parser->name(), buf);
    if ((tree->childs != NULL) && (tree->numChild() > 0)) {
        printf("(\n");
        for (int i = 0; i < tree->numChild(); i++) {
            printSyntaxTree(tree->get(i), inp, indent+1);
        }
        printf("%s)\n", is);
    } else {
        printf("\n");
    }
}
