
#include "errortest.tab.h"
#include <stdio.h>


extern int g_errorId;
extern u32 g_pos;

int total, count;


void SyntaxTree::action(void) {}


void test(const char* str, Parser* parser, int errId)
{
    extern void printSyntaxTree(Houken::SyntaxTree* tree, Houken::InputBuffer* inp, int indent = 0);
    g_errorId = 0;
    ++total;
    StringInputBuffer inp(str);
    gpInp = &inp;
    SyntaxTree* st = parser->parse();
    //printSyntaxTree(st, Parser::getInputBuffer());
    if (g_errorId == errId)
        ++count;
    else
        printf("fail %d\n", total);
}


void printError(InputBuffer* inp)
{
    int n = Parser::numErrors();
    for (--n; n >= 0; --n) {
        Parser::Error_t err = Parser::getError(n);
        char pbuf[128];
        inp->sprintSourceInfo(pbuf, 128, err.pos);
        const char* nam = err.parser->name();
        if ((nam != NULL) && (*nam != '('))
            printf("parser=%s, %s\n", nam, pbuf);
    }
}

int main(int argc, const char* argv[])
{
    Parser::setUseMemoize(false);
    Parser::setPrintIntermediateLevel(0);

    StringInputBuffer inp("dummy");
    gpInp = &inp;
    Parser::initialize(50);

    test("abcdefghi", p_testA, 0);
    test("abcdefghi", p_testB, 0);
    test("abczzz", p_testA, 1);
    test("abczzz", p_testB, 1);
    test("ghizzz", p_testB, 2);

    test("zzz", p_testC, 0);
    test("abcdefzzz", p_testC, 0);
    test("abczzz", p_testC, 1);

    test("zzz", p_testD, 0);
    test("abcdefzzz", p_testD, 0);
    test("abczzz", p_testD, 1);
    test("abcdefabczzz", p_testD, 1);
    test("abcdefabcdef", p_testD, 0);

    test("zzz", p_testE, 0);
    test("abcdefzzz", p_testE, 0);
    test("abczzz", p_testE, 1);
    test("abcdefabczzz", p_testE, 1);
    test("abcdefabcdef", p_testE, 0);

    printf("passed %d / total %d\n", count, total);

    Parser::finalize();
    SyntaxTree::finalize();

    return total - count;
}
