
#ifndef _SYNTAXTREE_H_
#define _SYNTAXTREE_H_

#include "sysDep.h"
#include "TArray.h"
#include "PtrArray.h"
#include "Substr.h"


// user defined application class
//    used in UserParser::action()
class Application;
using ::Application;

namespace Houken {
    class Parser;
    class InputBuffer;
    class SyntaxTree {
    public:
        enum Valid_e {
            V_VALID,     // childs is valid
            V_INVALID,   // childs is not valid
            V_ERRORCUT,  // ErrorCut, errorCutId is valid
            V_FAIL,      // parse failed
            V_ERROR,     // parse error, errorCutId is valid
            V_FATAL_ERROR, // fatal error
        };
    public:
        SyntaxTree(Valid_e v = V_INVALID);
        SyntaxTree(Parser* p, u32 startPos, u32 endPos, PtrArray<SyntaxTree>* ch = NULL);
        SyntaxTree(Parser* p, Substr& ss, PtrArray<SyntaxTree>* ch = NULL);
        SyntaxTree(Parser* p, Substr& ss, int errId); // create Error Cut
        SyntaxTree(u32 errPos, int errId, Parser* p); // create Error
        ~SyntaxTree();

        void* operator new(size_t);
        void operator delete(void*);

        void action(Application*);

        int             numChild(void) { return childs->size(); }
        SyntaxTree*     get(int idx) { return childs->get(idx); }
        SyntaxTree*     extract(int idx) { return childs->extract(idx); }
        SyntaxTree*     erase(int idx);         // delete child[idx]
        SyntaxTree*     shrink(void);           // pack all NULL gap
        void    deleteAllChild(void);

        // is childs valid ?
        bool            isValidTree(void) { return _valid == V_VALID; }
        bool            isFail(void) { return (_valid == V_FAIL) || isError(); }
        bool            isFailNotError(void) { return _valid == V_FAIL; }
        bool            isError(void) { return (_valid == V_ERROR) || (_valid == V_FATAL_ERROR); }
        bool            isFatalError(void) { return _valid == V_FATAL_ERROR; }
        bool            isErrorCut(void) { return _valid == V_ERRORCUT; }

        static void     finalize(void);

    public:
        Substr          str;
        Parser*         parser;
        union {
            PtrArray<SyntaxTree>*   childs;
            int         errorCutId;
        };

    protected:
        Valid_e         _valid;

    protected:
        static PtrArray<TArray<SyntaxTree> > _memPool;
        
    };


    extern SyntaxTree* const _PARSE_FAILED;   // parse result failed
    extern SyntaxTree* const _NO_SYNTAX_TREE; // tree disposed
    extern SyntaxTree* const _FATAL_PARSER_ERROR; // left recursion or something
    extern SyntaxTree* const _NOT_PARSED_YET; // Memoize; not parsed yet
    extern SyntaxTree* const _PARSING;        // Memoize; now parsing
    
}

#endif /* _SYNTAXTREE_H_ */
