
#ifndef _MEMOIZE_H_
#define _MEMOIZE_H_

#include "TArray.h"
#include "sysDep.h"


namespace Houken {

    class SyntaxTree;
    
    class Memoize {
    public:
        Memoize(void);
        ~Memoize();

        SyntaxTree*     getAt(u32 pos);
        void            setAt(u32 pos, SyntaxTree* st);
        void            remove(SyntaxTree* st);  // remove memo including st
        int             size(void) { return _memoArr.size(); }

    protected:
        int     _search(u32 pos);

    protected:
        struct Memo {
            u32 pos;
            SyntaxTree* st;
        };
        TArray<Memo>    _memoArr;       // sorted by pos
    };

}

#endif /* _MEMOIZE_H_ */
