
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "calc.tab.h"
#include "../etc/printSyntaxTree.h"


struct Application {
    int x;
};

using namespace Houken;


//============================================================
//@ Start <- %Spc Exp %EOF
void P_Start::actionAtParse(SyntaxTree*){}
void P_Start::action(SyntaxTree* tree, Application* ap)
{
    tree->get(0)->action(ap);
}


//------------------------------------------------------------
//@

//============================================================
//@ Exp <- Number / Paren
//expanded as below:
// Exp <- Exp__5
// Exp__0 <- Number / Paren
void P_Exp::actionAtParse(SyntaxTree*){}
void P_Exp::action(SyntaxTree* tree, Application* ap)
{
    tree->get(0)->action(ap);
}
void P_Exp__0::actionAtParse(SyntaxTree*){}
void P_Exp__0::action(SyntaxTree* tree, Application* ap)
{
    tree->get(0)->action(ap);
}

//============================================================
//@ Exp << infixl 10 ("+" / "-") %Spc
//expanded nearly as below (avoiding left recursion):
// Exp__10 <- Exp__20 / Exp__10 (("+" / "-") %Spc) Exp__20
void P_Exp__10::action(SyntaxTree* tree, Application* ap)
{
    Application rh;
    tree->get(0)->action(ap);
    if (tree->numChild() >= 3) {
        tree->get(2)->action(&rh);
        wchar_t opchar = _inp->getCharAt(tree->get(1)->str.startPos);
        switch(opchar) {
        case L'+':
            ap->x += rh.x;
            break;
        case L'-':
            ap->x -= rh.x;
            break;
        default:
            printf("error on P_Exp__10: %c\n",(char)opchar);
            ap->x = 0;
        }
    }
    tree->deleteAllChild();
}


//============================================================
//@ Exp << infixl 20 ("*" / "/") %Spc
//expanded nearly as below (avoiding left recursion):
// Exp__20 <- Exp__30 / Exp__20 (("*" / "/") %Spc) Exp__30
void P_Exp__20::action(SyntaxTree* tree, Application* ap)
{
    Application rh;
    tree->get(0)->action(ap);
    if (tree->numChild() >= 3) {
        tree->get(2)->action(&rh);
        wchar_t opchar = _inp->getCharAt(tree->get(1)->str.startPos);
        switch(opchar) {
        case L'*':
            ap->x *= rh.x;
            break;
        case L'/':
            ap->x /= rh.x;
            break;
        default:
            printf("error on P_Exp__20: %c\n",(char)opchar);
            ap->x = 0;
        }
    }
    tree->deleteAllChild();
}


//============================================================
//@ Exp << infixr 30 "**" %Spc
//expanded as below:
// Exp__30 <- Exp__40 ("**" %Spc Exp__30)?
void P_Exp__30::action(SyntaxTree* tree, Application* ap)
{
    Application rh;
    tree->get(0)->action(ap);
    if (tree->numChild() >= 3) {
        tree->get(2)->action(&rh);
        ap->x = (int)powf((float)ap->x, (float)rh.x);
    }
    tree->deleteAllChild();
}

//============================================================
//@ Exp << prefix 40 ("+" / "-") %Spc
//expanded as below:
// Exp__40 <- (("+" / "-") %Spc)? Exp__0
void P_Exp__40::action(SyntaxTree* tree, Application* ap)
{
    if (tree->numChild() == 1) {
        tree->get(0)->action(ap);
    } else {
        tree->get(1)->action(ap);
        wchar_t opchar = _inp->getCharAt(tree->get(0)->str.startPos);
        switch(opchar) {
        case L'+':
            break;
        case L'-':
            ap->x = - ap->x;
            break;
        default:
            printf("error on P_Exp__40: %c\n",(char)opchar);
            ap->x = 0;
        }
    }
    tree->deleteAllChild();
}

//============================================================
//@ Exp << ternary 5 ("?" %Spc) (":" %Spc)
//expanded as below:
// Exp__5 <- Exp__10 (("?" %Spc) Exp__10 (":" %Spc) Exp__10)?
void P_Exp__5::action(SyntaxTree* tree, Application* ap)
{
    tree->get(0)->action(ap);
    if (tree->numChild() >= 5) {
        if (ap->x != 0)
            tree->get(2)->action(ap);
        else
            tree->get(4)->action(ap);
    }
    tree->deleteAllChild();
}

//------------------------------------------------------------
//@
//@

//============================================================
//@ Number <- %[0-9]+ %Spc
void P_Number::actionAtParse(SyntaxTree*){}
void P_Number::action(SyntaxTree* tree, Application* ap)
{
    int res = 0;
    for (u32 pos = tree->str.startPos; pos < tree->str.endPos; ++pos) {
        int c = _inp->getCharAt(pos) - L'0';
        if ((c < 0) || (c > 9))
            break;
        res *= 10;
        res += c;
    }
    ap->x = res;
}


//============================================================
//@ Paren <- %"(" %Spc Exp %")" %Spc
void P_Paren::actionAtParse(SyntaxTree*){}
void P_Paren::action(SyntaxTree* tree, Application* ap)
{
    tree->get(0)->action(ap);
}


//============================================================
//@ Spc <- %(" " / "\t")*
void P_Spc::actionAtParse(SyntaxTree*){}
void P_Spc::action(SyntaxTree*, Application*)
{
    // never called because all used as %Spc
    printf("error on P_Spc\n");
}

void printError(InputBuffer* inp)
{
    int n = Parser::numErrors();
    for (--n; n >= 0; --n) {
        Parser::Error_t err = Parser::getError(n);
        char pbuf[128];
        inp->posInfo(pbuf, 128, err.pos);
        const char* nam = err.parser->name();
        if ((nam != NULL) && (*nam != '('))
            printf("parser=%s, %s\n", nam, pbuf);
    }
}


int main(int argc, const char* argv[])
{
    if (argc < 2) {
        printf("expression required as argument\n");
        return 1;
    }
    StringInputBuffer inp(argv[1]);
    Parser::initialize(&inp, 40);
    Parser::setPrintIntermediateLevel(1);
    printf("%s ->\n", argv[1]);
    SyntaxTree* st = p_Start->parse();
    if (st->isValidTree()) {
        printSyntaxTree(st, &inp, 0);
        Application x;
        st->action(&x);
        printf("result = %d\n", x.x);
    } else {
        printf("parse error\n");
        printError(&inp);
    }
    delete st;
    Parser::finalize();
}
