
#include "PegParser.h"
#include "Operator.h"
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>


struct Application {
    int x;
};


static TArray<Substr> rules(16);
static TArray<Substr> genRules(16);

static bool haveErrorCut;

extern char* tab_basename;      // from main.cpp

static FILE* hfp = NULL;
static FILE* cppfp = NULL;
static FILE* tmplfp = NULL;
static Operator* op = NULL;

static void hOutOpen(void)
{
    char* tab_filename = new char[strlen(tab_basename) + 8];
    strcpy(tab_filename, tab_basename);
    strcat(tab_filename, ".tab.h");
    hfp = fopen(tab_filename, "w");

    char* p = tab_filename;
    while (*p != '\0') {
        if ((*p >= 'a') && (*p <= 'z'))
            *p -= 'a' - 'A';
        else if (*p == '.')
            *p = '_';
        ++p;
    }
    fprintf(hfp,
            "/* this file is generated by 'houken' parser generator */\n"
            "#ifndef _%s_\n"
            "#define _%s_\n"
            "\n"
            "#include \"Parser.h\"\n"
            "\n"
            "class Application;\n"
            "\n"
            "using namespace Houken;\n"
            "\n"
            "extern void p__init(void);\n"
            "\n"
            "#define USER_PARSER(klass, name, instance)    \\\n"
            "  class klass : public UserParser {           \\\n"
            "  public: klass(void) : UserParser(name) {}   \\\n"
            "      SyntaxTree* uParse(void);               \\\n"
            "      void action(SyntaxTree*, Application*); \\\n"
            "  };                                          \\\n"
            "  extern klass *      instance\n"
            "\n"
            "#define GEN_PARSER(klass, name, instance)    \\\n"
            "  class klass : public GenParser {           \\\n"
            "  public: klass(void) : GenParser(name) {}   \\\n"
            "      void construct(void);                   \\\n"
            "      void actionAtParse(SyntaxTree*);        \\\n"
            "      void action(SyntaxTree*, Application*); \\\n"
            "  };                                          \\\n"
            "  extern klass *      instance\n"
            "\n"
            "#define GEN_PARSER_E(klass, name, instance)  \\\n"
            "  class klass : public GenParser {           \\\n"
            "  public: klass(void) : GenParser(name) {}   \\\n"
            "      void construct(void);                   \\\n"
            "      void actionAtParse(SyntaxTree*);        \\\n"
            "      void action(SyntaxTree*, Application*); \\\n"
            "      void errorMessage(int errorId, u32 pos);\\\n"
            "  };                                          \\\n"
            "  extern klass *      instance\n"
            "\n"
            "#define OPERATOR_PARSER(klass, name, instance)\\\n"
            "  class klass : public OperatorParser {       \\\n"
            "  public: klass(void) : OperatorParser(name) {} \\\n"
            "      void construct(void);                   \\\n"
            "      void action(SyntaxTree*, Application*); \\\n"
            "  };                                          \\\n"
            "  extern klass *      instance\n"
            "\n"
            , tab_filename, tab_filename
            );
    delete[] tab_filename;
}

static void hOut(const char* fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vfprintf(hfp, fmt, ap);
    va_end(ap);
}

static void hOutClose(void)
{
    fprintf(hfp,
            "#undef USER_PARSER\n"
            "#undef GEN_PARSER\n"
            "#undef GEN_PARSER_E\n"
            "#undef OPERATOR_PARSER\n"
            "\n"
            "\n"
            "#endif\n"
            );            
    fclose(hfp);
}

static void cppOutOpen(void)
{
    char* tab_filename = new char[strlen(tab_basename) + 10];
    strcpy(tab_filename, tab_basename);
    strcat(tab_filename, ".tab.cpp");
    cppfp = fopen(tab_filename, "w");

    strcpy(tab_filename, tab_basename);
    strcat(tab_filename, ".tab.h");
    fprintf(cppfp,
            "/* this file is generated by 'houken' parser generator */\n"
            "#include <stdio.h>\n"
            "#include <string.h>\n"
            "#include \"%s\"\n"
            "\n"
            "\n"
            "using namespace Houken;\n"
            "\n"
            "Parser_EOF* p__eof;\n"
            "Parser_AnyChar* p__anychar;\n"
            , tab_filename
            );
    delete[] tab_filename;
}

static void cppOut(const char* fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vfprintf(cppfp, fmt, ap);
    va_end(ap);
}

static void cppOutDecl(InputBuffer* inp)
{
    // output rule decls
    TArrayIterator<Substr> ruleItr(&rules);
    char n[256];
    while (ruleItr.hasMore()) {
        Substr s = ruleItr.next();
        inp->copyStr(n, 256, s);
        fprintf(cppfp, "P_%s* p_%s;\n", n,n);
    }        
    TArrayIterator<Substr> expItr(op->expIdents());
    while (expItr.hasMore()) {
        Substr ss = expItr.next();
        inp->copyStr(n, 256, ss);
        TArray<u32>* precs = op->getPrecs(ss);
        TArrayIterator<u32> precItr(precs);
        fprintf(cppfp, "P_%s__0* p_%s__0;\n", n,n);
        while (precItr.hasMore()) {
            u32 prec = precItr.next();
            fprintf(cppfp, "P_%s__%d* p_%s__%d;\n", n,prec,n,prec);
        }
    }


    // output init func
    fprintf(cppfp,
            "\n"
            "void p__init(void)\n"
            "{\n"
            "  p__eof = new Parser_EOF();\n"
            "  p__anychar = new Parser_AnyChar();\n"
            );

    ruleItr.rewind();
    while (ruleItr.hasMore()) {
        Substr s = ruleItr.next();
        inp->copyStr(n, 256, s);
        fprintf(cppfp, "  p_%s = new P_%s();\n", n,n);
    }        
    expItr.rewind();
    while (expItr.hasMore()) {
        Substr ss = expItr.next();
        inp->copyStr(n, 256, ss);
        TArray<u32>* precs = op->getPrecs(ss);
        TArrayIterator<u32> precItr(precs);
        fprintf(cppfp, "  p_%s__0 = new P_%s__0();\n", n,n);
        while (precItr.hasMore()) {
            u32 prec = precItr.next();
            fprintf(cppfp, "  p_%s__%d = new P_%s__%d();\n", n,prec,n,prec);
        }
    }


    fprintf(cppfp, "\n");
    TArrayIterator<Substr> genRuleItr(&genRules);
    while (genRuleItr.hasMore()) {
        Substr s = genRuleItr.next();
        inp->copyStr(n, 256, s);
        fprintf(cppfp, "  p_%s->construct();\n", n);
    }        
    expItr.rewind();
    while (expItr.hasMore()) {
        Substr ss = expItr.next();
        inp->copyStr(n, 256, ss);
        TArray<u32>* precs = op->getPrecs(ss);
        TArrayIterator<u32> precItr(precs);
        fprintf(cppfp, "  p_%s__0->construct();\n", n);
        while (precItr.hasMore()) {
            u32 prec = precItr.next();
            fprintf(cppfp, "  p_%s__%d->construct();\n", n,prec);
        }
    }
    fprintf(cppfp, "}\n");
}

static void cppOutClose(void)
{
    fclose(cppfp);
}

static void tmplOutOpen(void)
{
    char* tab_filename = new char[strlen(tab_basename) + 12];
    strcpy(tab_filename, tab_basename);
    strcat(tab_filename, ".tab.tmpl");
    tmplfp = fopen(tab_filename, "w");

    strcpy(tab_filename, tab_basename);
    strcat(tab_filename, ".tab.h");
    fprintf(tmplfp,
            "#include \"%s\"\n"
            "\n"
            "\n"
            , tab_filename
            );
    delete[] tab_filename;
}

static void tmplOut(const char* fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vfprintf(tmplfp, fmt, ap);
    va_end(ap);
}

static void tmplOutComment(InputBuffer* inp, Substr str)
{
    u32 len = str.len();
    char* buf = new char[len+2];
    inp->copyStr(buf, len, str);
    char* p = buf;
    char* z = buf + len;
    while (p < z) {
        char* q = p;
        while (q < z) {
            if (*q == '\n' || *q == '\r' || *q == '\0')
                break;
            ++q;
        }
        if (q != p) {
            *q = '\0';
            tmplOut("//@ %s\n", p);
        }
        while (++q < z) {
            if (*q != '\n' && *q != '\r' && *q != '\0')
                break;
        }
        p = q;
    }
    delete[] buf;
}

static void tmplOutClose(void)
{
    fclose(tmplfp);
}


static u32 toNum(Substr& ss)
{
    InputBuffer* inp = Parser::getInputBuffer();
    const char* p = inp->addr(ss.startPos);
    const char* q = inp->addr(ss.endPos);
    u32 num = 0;
    while (p < q) {
        wchar_t c = inp->getCharAt(&p);
        if ((c < L'0') || (c > L'9'))
            break;
        num *= 10;
        num += c - L'0';
    }
    return num;
}

// comment for gaterRule.rb
//
//@ #
//@ # syntax definition of PEG itself
//@ #
//@
//@ $ctype C
//@
//


//============================================================
//@ Start <- Directives %Spc Rules %EOF
void P_Start::actionAtParse(SyntaxTree*) {}
void P_Start::action(SyntaxTree* st, Application*)
{
    tmplOutOpen();
    st->get(0)->action(NULL);
    st->get(1)->action(NULL);
    tmplOutClose();
}

//------------------------------------------------------------
//@

//============================================================
//@ Directives <- (%Spc Directive)*
void P_Directives::actionAtParse(SyntaxTree*){}
void P_Directives::action(SyntaxTree* st, Application*)
{
    tmplOutComment(_inp, st->str);
}
void P_Directive::errorMessage(int errorId, u32 pos)
{ GenParser::errorMessage(errorId, pos); }

//@ Rules <- (Rule / OperatorDef)*
void P_Rules::actionAtParse(SyntaxTree*){}
void P_Rules::action(SyntaxTree* st, Application*)
{
    if (st->numChild() < 1)
        return;
    hOutOpen();
    cppOutOpen();
    op = new Operator();
    PtrArrayIterator<SyntaxTree> itr(st->childs);
    bool errFlag = false;
    while (itr.hasMore()) {
        SyntaxTree* ch = itr.next();
        if (ch->parser == p_Rule) {
            SyntaxTree* ident = ch->get(0);
            rules.add(ident->str);
            genRules.add(ident->str);
        } else if (ch->parser == p_DummyRule) {
            SyntaxTree* ident = ch->get(0);
            rules.add(ident->str);
        } else if (ch->parser == p_OperatorDef) {
            SyntaxTree* ident = ch->get(0);     // Ident
            u32 num = toNum(ch->get(1)->get(1)->str);   // Number
            errFlag |= !op->entry(ident->str, num);
        }
    }

    if (! errFlag) {
        op->sort();
        cppOutDecl(_inp);
        itr.rewind();
        while (itr.hasMore())
            itr.next()->action(NULL);
    }
    hOutClose();
    cppOutClose();
    delete op;
    if (errFlag) {
        //delete output files ?
        fflush(stderr);
        exit(1);
    }
}


//------------------------------------------------------------
//@

//============================================================
//@ Directive <- %"$ctype" %(" " / "\t")+ XCharA+
void P_Directive::actionAtParse(SyntaxTree* st)
{
    Substr ss(st->get(0)->str.startPos, st->str.endPos);
    char n[256];
    _inp->copyStr(n, 256, ss);
#ifdef __CYGWIN__
    if (strcasecmp(n, "ja_JP.SJIS") == 0)
        strcpy(n, "C-SJIS");
    else if (strcasecmp(n, "ja_JP.eucjp") == 0)
        strcpy(n, "C-EUCJP");
#endif
    _inp->setLocale(n);
}
void P_Directive::action(SyntaxTree*, Application*){}

//------------------------------------------------------------
//------------------------------------------------------------
//------------------------------------------------------------

static void ruleOut(SyntaxTree* st, InputBuffer* inp, bool bDummy)
{
    PtrArrayIterator<SyntaxTree> itr(st->childs);
    SyntaxTree* ident = itr.next();
    char n[256];
    inp->copyStr(n, 256, ident->str);
    bool bOperand = op->isOperand(ident->str);
    cppOut("\n");
    if (bDummy)
        cppOut("/*\n");
    cppOut("void P_%s::construct(void) {\n", n);
    cppOut("  _parser = ");
    if (bOperand) {
        u32 lowest = op->getPrecs(ident->str)->get(0);
        cppOut("p_%s__%d;\n}\n", n,lowest);
        cppOut("\nvoid P_%s__0::construct(void) {\n", n);
        cppOut("  _parser = ");
    }
    haveErrorCut = false;
    while (itr.hasMore()) {
        itr.next()->action(NULL);
    }
    cppOut(";\n}\n");
    const char* ug = "GEN";
    if (bDummy) {
        cppOut("*/\n");
        ug = "USER";
    }

    const char* he = haveErrorCut ? "_E" : "";
    if (bOperand) {
        hOut("GEN_PARSER(P_%s, \"%s\", p_%s);\n",n,n,n);
        hOut("%s_PARSER%s(P_%s__0, \"%s__0\", p_%s__0);\n",ug,he,n,n,n);
    } else {
        hOut("%s_PARSER%s(P_%s, \"%s\", p_%s);\n",ug,he,n,n,n);
    }

    tmplOut("\n//============================================================\n");
    tmplOutComment(inp, st->str);

    const char* opr = bOperand ? "__0" : "";
    if (bDummy) {
        tmplOut("SyntaxTree* P_%s%s::uParse(void){}\n",n,opr);
    } else {
        tmplOut("void P_%s%s::actionAtParse(SyntaxTree*){}\n",n,opr);
        if (haveErrorCut) {
            tmplOut("void P_%s%s::errorMessage(int errorId, u32 pos)\n",n,opr);
            tmplOut("{ GenParser::errorMessage(errorId, pos); }\n");
        }
    }
    tmplOut("void P_%s%s::action(SyntaxTree*, Application*){}\n",n,opr);
}

//============================================================
//@ Rule <- Ident %Spc %"<-" %Spc Disjunction
void P_Rule::actionAtParse(SyntaxTree*){}
void P_Rule::action(SyntaxTree* st, Application*)
{
    ruleOut(st, _inp, false);
}

//============================================================
//@ DummyRule <- Ident %Spc %"<-" %Spc Disjunction
void P_DummyRule::actionAtParse(SyntaxTree*){}
void P_DummyRule::action(SyntaxTree* st, Application*)
{
    ruleOut(st, _inp, true);
}

//============================================================
//@ Disjunction <- Conjunction (%"/" %Spc Conjunction)*
void P_Disjunction::actionAtParse(SyntaxTree*){}
void P_Disjunction::action(SyntaxTree* st, Application*)
{
    PtrArrayIterator<SyntaxTree> itr(st->childs);
    itr.next()->action(NULL);
    while (itr.hasMore()) {
        cppOut("->choice(");
        itr.next()->action(NULL);
        cppOut(")");
    }
}

//============================================================
//@ Conjunction <- (PrefixExp / ErrorCut)+
void P_Conjunction::actionAtParse(SyntaxTree*){}
void P_Conjunction::action(SyntaxTree* st, Application*)
{
    PtrArrayIterator<SyntaxTree> itr(st->childs);
    itr.next()->action(NULL);
    while (itr.hasMore()) {
        cppOut("->seq(");
        itr.next()->action(NULL);
        cppOut(")");
    }
}

//============================================================
//@ PrefixExp <- (AndPred / NotPred / NoTree)? SuffixExp
void P_PrefixExp::actionAtParse(SyntaxTree*){}
void P_PrefixExp::action(SyntaxTree* st, Application*)
{
    if (st->numChild() == 1) {
        st->get(0)->action(NULL);
    } else {
        st->get(1)->action(NULL);
        st->get(0)->action(NULL);
    }
}

//============================================================
//@ SuffixExp <- Term %Spc (Optional / ZeroOrMore / OneOrMore)?
void P_SuffixExp::actionAtParse(SyntaxTree*){}
void P_SuffixExp::action(SyntaxTree* st, Application*)
{
    if (st->numChild() == 1) {
        st->get(0)->action(NULL);
    } else {
        st->get(0)->action(NULL);
        st->get(1)->action(NULL);
    }
}

//============================================================
//@ Term <- EndOfFile / Term1 / Term2 / String / Token / Range / Char / AnyChar
void P_Term::actionAtParse(SyntaxTree*){}
void P_Term::action(SyntaxTree* st, Application*)
{
    st->get(0)->action(NULL);
}

//============================================================
//@ Term1 <- %Ident !(Spc "<")
void P_Term1::actionAtParse(SyntaxTree*){}
void P_Term1::action(SyntaxTree* st, Application*)
{
    u32 len = st->str.len();
    char* n = new char[len+1];
    _inp->copyStr(n, len, st->str);
    cppOut("p_%s", n);
    delete[] n;
}

//============================================================
//@ Term2 <- %"(" %Spc Disjunction %")"
void P_Term2::actionAtParse(SyntaxTree*){}
void P_Term2::action(SyntaxTree* st, Application*)
{
    st->get(0)->action(NULL);
}

//============================================================
//@ ErrorCut <- %"$" $1 Number %Spc
void P_ErrorCut::actionAtParse(SyntaxTree*){}
void P_ErrorCut::action(SyntaxTree* st, Application*)
{
    u32 errId = toNum(st->get(0)->str);
    cppOut("(new Parser_ErrorCut(%d))", errId);
    haveErrorCut = true;
}
void P_ErrorCut::errorMessage(int errorId, u32 pos)
{ GenParser::errorMessage(errorId, pos); }


//------------------------------------------------------------
//@

//============================================================
//@ OperatorDef <- Ident %Spc %"<<" $1 %Spc (BinaryOp / TernaryOp)
void P_OperatorDef::actionAtParse(SyntaxTree*){}
void P_OperatorDef::action(SyntaxTree* st, Application*)
{
    SyntaxTree* ident = st->get(0);
    char id[256];
    _inp->copyStr(id, 256, ident->str);

    SyntaxTree* opdef = st->get(1);
    PtrArrayIterator<SyntaxTree> itr(opdef->childs);
    SyntaxTree* spec = itr.next();
    u32 prec = toNum(itr.next()->str);
    u32 higher = op->getHigher(ident->str, prec);

    hOut("OPERATOR_PARSER(P_%s__%d, \"%s__%d\", p_%s__%d);\n",id,prec,id,prec,id,prec);
    cppOut("\nvoid P_%s__%d::construct(void) {\n", id,prec);
    if (_inp->strcmp(spec->str, "infixl")) {
        cppOut("  _parser = new Parser_InfixL(p_%s__%d, p_%s__%d, ", id,prec, id,higher);
        itr.next()->action(NULL);       // Disjunction
    } else if (_inp->strcmp(spec->str, "infixr")) {
        cppOut("  _parser = new Parser_InfixR(p_%s__%d, p_%s__%d, ", id,prec, id,higher);
        itr.next()->action(NULL);       // Disjunction
    } else if (_inp->strcmp(spec->str, "infixn")) {
        cppOut("  _parser = new Parser_InfixN(p_%s__%d, p_%s__%d, ", id,prec, id,higher);
        itr.next()->action(NULL);       // Disjunction
    } else if (_inp->strcmp(spec->str, "prefix")) {
        cppOut("  _parser = new Parser_Prefix(p_%s__%d, ", id,higher);
        itr.next()->action(NULL);       // Disjunction
    } else if (_inp->strcmp(spec->str, "postfix")) {
        cppOut("  _parser = new Parser_Postfix(p_%s__%d, ", id,higher);
        itr.next()->action(NULL);       // Disjunction
    } else if (_inp->strcmp(spec->str, "ternary")) {
        cppOut("  _parser = new Parser_Ternary(p_%s__%d, ", id,higher);
        itr.next()->action(NULL);       // Term
        cppOut(", ");
        itr.next()->action(NULL);       // Term
    } else {
        _inp->copyStr(id, 256, spec->str);
        fprintf(stderr, "unknown operator spec %s\n", id);
        fflush(stderr);
        exit(1);
    }

    cppOut(");\n}\n");

    tmplOut("\n//============================================================\n");
    tmplOutComment(_inp, st->str);
    tmplOut("void P_%s__%d::action(SyntaxTree*, Application*){}\n",id,prec);
}
void P_OperatorDef::errorMessage(int errorId, u32 pos)
{ GenParser::errorMessage(errorId, pos); }

//============================================================
//@ BinaryOp <- ('infixl' / 'infixr' / 'infixn' / 'prefix' / 'postfix') $1 %Spc Number $2 %Spc Disjunction
void P_BinaryOp::actionAtParse(SyntaxTree*){}
void P_BinaryOp::action(SyntaxTree* st, Application*)
{
}
void P_BinaryOp::errorMessage(int errorId, u32 pos)
{ GenParser::errorMessage(errorId, pos); }


//============================================================
//@ TernaryOp <- 'ternary' $1 %Spc Number $2 %Spc Term %Spc Term %Spc
void P_TernaryOp::actionAtParse(SyntaxTree*){}
void P_TernaryOp::action(SyntaxTree* st, Application*)
{
}
void P_TernaryOp::errorMessage(int errorId, u32 pos)
{ GenParser::errorMessage(errorId, pos); }

//============================================================
//@ Number		<% %[0-9]+
SyntaxTree* P_Number::uParse(void)
{
    _ErrorPos startPos = _curErrPos();
    if (_inp->skip_decimalNum()) {
        return createSyntaxTree(startPos.parsePos);
    }
    _fail(startPos);
    return _PARSE_FAILED;
}
void P_Number::action(SyntaxTree*, Application*){}

//------------------------------------------------------------
//@

//============================================================
//@ AndPred <- %"&" %Spc
void P_AndPred::actionAtParse(SyntaxTree*){}
void P_AndPred::action(SyntaxTree*, Application*)
{
    cppOut("->andPred()");
}

//============================================================
//@ NotPred <- %"!" %Spc
void P_NotPred::actionAtParse(SyntaxTree*){}
void P_NotPred::action(SyntaxTree*, Application*)
{
    cppOut("->notPred()");
}

//============================================================
//@ NoTree <- %"%" %Spc
void P_NoTree::actionAtParse(SyntaxTree*){}
void P_NoTree::action(SyntaxTree*, Application*)
{
    cppOut("->noTree()");
}

//============================================================
//@ Optional <- %"?" %Spc
void P_Optional::actionAtParse(SyntaxTree*){}
void P_Optional::action(SyntaxTree*, Application*)
{
    cppOut("->optional()");
}

//============================================================
//@ ZeroOrMore <- %"*" %Spc
void P_ZeroOrMore::actionAtParse(SyntaxTree*){}
void P_ZeroOrMore::action(SyntaxTree*, Application*)
{
    cppOut("->star()");
}

//============================================================
//@ OneOrMore <- %"+" %Spc
void P_OneOrMore::actionAtParse(SyntaxTree*){}
void P_OneOrMore::action(SyntaxTree*, Application*)
{
    cppOut("->plus()");
}

//------------------------------------------------------------
//@

//============================================================
//@ Ident <% %Ident1 %Ident2*
SyntaxTree* P_Ident::uParse(void)
{
    _ErrorPos startPos = _curErrPos();
    if (_inp->skip_ident()) {
        return createSyntaxTree(startPos.parsePos);
    }
    _fail(startPos);
    return _PARSE_FAILED;
}
void P_Ident::action(SyntaxTree*, Application*){}

//============================================================
//@ NotTokenPred <% !Ident2
SyntaxTree* P_NotTokenPred::uParse(void)
{
    wchar_t c = _inp->getChar();
    _inp->ungetChar();
    if (c >= L'a' && c <= L'z')
        return _PARSE_FAILED;
    if (c >= L'0' && c <= L'9')
        return _PARSE_FAILED;
    if (c >= L'A' && c <= L'Z')
        return _PARSE_FAILED;
    if (c == L'_')
        return _PARSE_FAILED;
    return _NO_SYNTAX_TREE;
}
void P_NotTokenPred::action(SyntaxTree*, Application*){}

//------------------------------------------------------------
//@

//============================================================
//@ EndOfFile <- %"EOF" !Ident2
void P_EndOfFile::actionAtParse(SyntaxTree*){}
void P_EndOfFile::action(SyntaxTree*, Application*)
{
    cppOut("p__eof");
}

//============================================================
//@ AnyChar <- %"."
void P_AnyChar::actionAtParse(SyntaxTree*){}
void P_AnyChar::action(SyntaxTree*, Application*)
{
    cppOut("p__anychar");
}

//============================================================
//@ String <- %"\"" (!"\"" %XChar)+ %"\""
void P_String::actionAtParse(SyntaxTree*){}
void P_String::action(SyntaxTree* st, Application*)
{
    char n[256];
    _inp->copyStr(n, 256, st->str);
    cppOut("(new Parser_String(%s))", n);
}

//============================================================
//@ Token <- %"'" Ident %"'"
void P_Token::actionAtParse(SyntaxTree*){}
void P_Token::action(SyntaxTree* st, Application*)
{
    st = st->get(0);
    char n[256];
    _inp->copyStr(n, 256, st->str);
    cppOut("(new Parser_String(\"%s\"))->seq(p_NotTokenPred->noTree())", n);
}

//============================================================
//@ Range <- %"[" XChar %"-" XChar %"]"
void P_Range::actionAtParse(SyntaxTree*){}
void P_Range::action(SyntaxTree* st, Application*)
{
    cppOut("(new Parser_RangeChar(");
    st->get(0)->action(NULL);
    cppOut(",");
    st->get(1)->action(NULL);
    cppOut("))");
}

//============================================================
//@ XChar <- XCharH / XCharE / XCharA
void P_XChar::actionAtParse(SyntaxTree*){}
void P_XChar::action(SyntaxTree* st, Application*)
{
    st->get(0)->action(NULL);
}

//============================================================
//@ XCharH <- %"\\" %("x" / "X") Hex1 Hex1
void P_XCharH::actionAtParse(SyntaxTree*){}
void P_XCharH::action(SyntaxTree* st, Application*)
{
    int i;
    Application x;
    st->get(0)->action(&x);
    i = 16 * x.x;
    st->get(1)->action(&x);
    i += x.x;
    cppOut("((wchar_t)%d)", i);
}

//============================================================
//@ XCharE <- %"\\" .
void P_XCharE::actionAtParse(SyntaxTree*){}
void P_XCharE::action(SyntaxTree* st, Application*)
{
    wchar_t wc = _inp->getCharAt(st->get(0)->str.startPos);
    cppOut("L'\\%lc'", wc);
}

//============================================================
//@ XCharA <- !("\n" / "\r") %.
void P_XCharA::actionAtParse(SyntaxTree*){}
void P_XCharA::action(SyntaxTree* st, Application*)
{
    wchar_t wc = _inp->getCharAt(st->str.startPos);
    cppOut("L'%lc'", wc);
}

//============================================================
//@ Hex1 <- %[0-9] / %[A-F] / %[a-f]
void P_Hex1::actionAtParse(SyntaxTree*){}
void P_Hex1::action(SyntaxTree* st, Application* ap)
{
    wchar_t wc = _inp->getCharAt(st->str.startPos);
    int v = 0;
    if ((wc >= L'0') && (wc <= L'9'))
        v = wc - L'0';
    else if ((wc >= L'A') && (wc <= L'F'))
        v = wc - L'A' + 10;
    else if ((wc >= L'a') && (wc <= L'f'))
        v = wc - L'A' + 10;
    else
        assert(false);
    ap->x = v;
}

//============================================================
//@ Spc <- %(Comment / " " / "\t" / "\n" / "\r")*
void P_Spc::actionAtParse(SyntaxTree*){}
void P_Spc::action(SyntaxTree*, Application*){}

//============================================================
//@ Comment <% %"#" %XCharA* %("\n" / "\r")+
SyntaxTree* P_Comment::uParse(void)
{
    _ErrorPos startPos = _curErrPos();
    wchar_t c = _inp->getChar();
    if (c == L'#') {
        _inp->skip_beforeEol();
        _inp->skip_eols();
        return createSyntaxTree(startPos.parsePos);
    }
    _fail(startPos);
    return _PARSE_FAILED;
}
void P_Comment::action(SyntaxTree*, Application*){}
