/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.text.MessageFormat;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.javahl.SVNAdmin;
import org.tigris.subversion.javahl.SVNClient;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;

public class JhlClientAdapter
extends AbstractJhlClientAdapter {
    private SVNAdmin svnAdmin;

    public JhlClientAdapter() {
        this.svnClient = new SVNClient();
        this.svnAdmin = new SVNAdmin();
        this.notificationHandler = new JhlNotificationHandler();
        this.svnClient.notification2((Notify2)this.notificationHandler);
        this.svnClient.setPrompt((PromptUserPassword)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
    }

    public static boolean isAvailable() {
        return JhlClientAdapterFactory.isAvailable();
    }

    public static String getLibraryLoadErrors() {
        return JhlClientAdapterFactory.getLibraryLoadErrors();
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        try {
            String fsType = repositoryType == null ? "fsfs" : repositoryType;
            this.notificationHandler.setCommand(23);
            String target = JhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine(MessageFormat.format("create --fstype {0} {1}", fsType, target));
            this.svnAdmin.create(target, false, false, null, fsType);
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }
}

