/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.svnserver;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.model.PropertyManager;
import com.interpress_project.modernshare.svnserver.RequestThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class ServerManager
extends Thread {
    private final SystemBase sb = SystemBase.getInstance();
    private InetAddress hostaddr;
    private SSLServerSocket serverSocket;
    private PropertyManager propmgr = PropertyManager.getInstance();
    private boolean bShutdown = false;
    private int listen_port = 0;
    private int tcpbufsz = 0;
    private ThreadPoolExecutor requestThreadPool;

    public ServerManager() {
        int THREAD_INITIALCOUNT = this.propmgr.getSVNServerThreadMinimum();
        int THREAD_MAXCOUNT = this.propmgr.getSVNServerThreadMaximum();
        this.CreateServerSocket();
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        this.requestThreadPool = new ThreadPoolExecutor(THREAD_INITIALCOUNT, THREAD_MAXCOUNT, 32L, TimeUnit.SECONDS, queue);
        this.sb.getLogger().debug((Object)"ServerManager started.");
    }

    private void CreateServerSocket() {
        this.listen_port = this.propmgr.getSVNServerPort();
        this.tcpbufsz = this.propmgr.getTcpBufSz();
        Properties props = System.getProperties();
        props.setProperty("javax.net.ssl.keyStore", this.propmgr.getKeystore());
        props.setProperty("javax.net.ssl.keyStorePassword", this.propmgr.getKeystorePass());
        try {
            this.hostaddr = InetAddress.getByName(this.propmgr.getServerName());
        }
        catch (UnknownHostException ex) {
            this.sb.getLogger().fatal((Object)("Fail to resolve the hostname,  " + this.propmgr.getServerName() + ". Server is forcely terminated."), (Throwable)ex);
            System.exit(-1);
        }
        try {
            SSLServerSocketFactory sslserversocketfactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            this.serverSocket = (SSLServerSocket)sslserversocketfactory.createServerSocket();
            this.serverSocket.setReceiveBufferSize(this.tcpbufsz);
            this.serverSocket.setReuseAddress(true);
            this.serverSocket.setSoTimeout(12000);
            InetSocketAddress endpoint = new InetSocketAddress(this.hostaddr, this.listen_port);
            this.serverSocket.bind(endpoint, 64);
        }
        catch (IOException ex) {
            this.sb.getLogger().fatal((Object)"Fail to start up secure guard. Server is forcely terminated.", (Throwable)ex);
            System.exit(-1);
        }
    }

    @Override
    public void run() {
        this.sb.getLogger().info((Object)("SVN Server name : " + this.propmgr.getServerName()));
        this.sb.getLogger().info((Object)("SVN Server port : " + this.propmgr.getSVNServerPort()));
        try {
            this.tcpbufsz = this.serverSocket.getReceiveBufferSize();
            this.sb.getLogger().info((Object)("SVN buffer size : " + this.tcpbufsz + "(byte)"));
        }
        catch (SocketException ex) {
            // empty catch block
        }
        this.sb.getLogger().info((Object)("SVN Server thread pool(min) : " + this.propmgr.getSVNServerThreadMinimum()));
        this.sb.getLogger().info((Object)("SVN Server thread pool(max) : " + this.propmgr.getSVNServerThreadMaximum()));
        this.sb.getLogger().info((Object)"Secure guard started.");
        int targetport = Integer.parseInt(this.propmgr.getSVNServerCommandPort());
        int timeout = 5000;
        int threadTimeout = this.propmgr.getThreadTimeout();
        while (!this.bShutdown) {
            try {
                Socket socket = this.serverSocket.accept();
                if (this.bShutdown) break;
                this.sb.getLogger().debug((Object)"Connection accepted...");
                this.requestThreadPool.execute(new RequestThread(socket, targetport, this.tcpbufsz, timeout, threadTimeout));
            }
            catch (Exception ex) {}
        }
        this.sb.getLogger().debug((Object)"Leave ServerManager mainloop().");
    }

    public void shutdown() {
        this.bShutdown = true;
        this.requestThreadPool.shutdownNow();
        try {
            Socket clientSocket = new Socket(this.hostaddr, this.listen_port);
            clientSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sb.getLogger().debug((Object)"ServerManager terminated.");
    }

    public void dispose() {
        this.shutdown();
    }
}

