/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.svnserver;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.model.PropertyManager;
import com.interpress_project.modernshare.serveradm.CommandExecutor;
import com.interpress_project.modernshare.serveradm.exceptions.CommandExecutorException;
import com.interpress_project.modernshare.serveradm.exceptions.NoSVNInstalledException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;

public class SVNServeManager
extends Thread {
    private PropertyManager propmgr;
    private final SystemBase sb = SystemBase.getInstance();
    private final String pidfile = "./pid";
    private String rootdir = null;
    private String port = null;
    private String svnserve = null;

    public SVNServeManager() {
        this.propmgr = PropertyManager.getInstance();
    }

    @Override
    public void run() {
        this.sb.getLogger().debug((Object)"Enter start().");
        this.init();
        if (this.isSVNServeRunning()) {
            this.sb.getLogger().warn((Object)"svnserve already may run, so it get to be terminated forcely.");
            this.killSVNServeCommand();
            this.sb.getLogger().warn((Object)"svnserver is terminated.");
        }
        if (this.isPortOccupancy()) {
            this.sb.getLogger().fatal((Object)("Port " + this.port + " is occupancy by other process. Please make it vacancy."));
            this.sb.getLogger().fatal((Object)"Server is forcely terminated.");
            System.exit(-1);
        }
        this.startupSVNServeCommand();
        this.sb.getLogger().info((Object)"svnserver started.");
    }

    private void init() {
        try {
            this.svnserve = this.propmgr.getSVNServerCommand();
            this.rootdir = this.propmgr.getSVNRootdir();
            this.port = this.propmgr.getSVNServerCommandPort();
        }
        catch (NoSVNInstalledException ex) {
            this.sb.getLogger().fatal((Object)ex.getMessage(), (Throwable)ex);
            System.exit(-1);
        }
    }

    private boolean isSVNServeRunning() {
        File file = new File("./pid");
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killSVNServeCommand() {
        String targetport = null;
        File file = new File("./pid");
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            return;
        }
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)fis, "US-ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            this.sb.getLogger().fatal((Object)ex);
            this.sb.getLogger().fatal((Object)"Server is forcely terminated.");
            System.exit(-1);
        }
        try {
            targetport = br.readLine();
        }
        catch (IOException ex) {
            this.sb.getLogger().fatal((Object)"IOException reading a line in pidfile, ./pid : ", (Throwable)ex);
            this.sb.getLogger().fatal((Object)"Server is forcely terminated.");
            System.exit(-1);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {}
        }
        try {
            Integer.valueOf(targetport.trim());
        }
        catch (NumberFormatException ex) {
            this.sb.getLogger().fatal((Object)("Invalid port number," + targetport + " found in " + "./pid"));
            this.sb.getLogger().fatal((Object)"Server is forcely terminated.");
            System.exit(-1);
        }
        ArrayList<String> list = new ArrayList<String>();
        CommandExecutor command = new CommandExecutor(true);
        list.add("kill");
        list.add(targetport.trim());
        try {
            command.execute(list);
        }
        catch (CommandExecutorException ex) {
            this.sb.getLogger().fatal((Object)("Exception executing command: " + list.toString()), (Throwable)ex);
            this.sb.getLogger().fatal((Object)"Server is forcely terminated.");
            System.exit(-1);
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPortOccupancy() {
        Socket socket = new Socket();
        InetSocketAddress endpoint = new InetSocketAddress("127.0.0.1", Integer.parseInt(this.port));
        try {
            socket.connect(endpoint);
            boolean bl = true;
            return bl;
        }
        catch (ConnectException ex) {
        }
        catch (IOException ex) {
            this.sb.getLogger().fatal((Object)"Exception connecting with socket. Server is forcely terminated. ", (Throwable)ex);
            System.exit(-1);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private void startupSVNServeCommand() {
        ArrayList<String> list = new ArrayList<String>();
        CommandExecutor command = new CommandExecutor(false);
        list.add(this.svnserve);
        list.add("-d");
        list.add("--pid-file");
        list.add("./pid");
        list.add("--listen-host");
        list.add("127.0.0.1");
        list.add("--listen-port");
        list.add(this.port);
        list.add("--root");
        list.add(this.rootdir);
        try {
            command.execute(list);
        }
        catch (CommandExecutorException ex) {
            this.sb.getLogger().fatal((Object)"Server is forcely terminated.", (Throwable)ex);
            System.exit(-1);
        }
    }

    public void dispose() {
        this.sb.getLogger().debug((Object)"Enter dispose()");
        this.killSVNServeCommand();
    }
}

