/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.svnserver;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;

public class RequestThread
extends Thread {
    private final SystemBase sb = SystemBase.getInstance();
    private Socket requestSocket = null;
    private Socket tgtSocket = null;
    private int targetport = 0;
    private int tcpbufsz = 0;
    private int connectionTimeout = 0;
    private int total_count = 0;
    private int out_count = 0;
    private int bufsz = 32768;
    private BufferedInputStream sock_bis = null;
    private BufferedInputStream svnsock_bis = null;
    private BufferedOutputStream sock_bos = null;
    private BufferedOutputStream svnsock_bos = null;

    public RequestThread(Socket socket, int targetport, int tcpbufsz, int connectionTimeout, int threadTimeout) {
        this.requestSocket = socket;
        this.targetport = targetport;
        this.tcpbufsz = tcpbufsz;
        this.connectionTimeout = connectionTimeout;
        try {
            this.requestSocket.setSendBufferSize(tcpbufsz);
            this.requestSocket.setKeepAlive(true);
            this.requestSocket.setTcpNoDelay(true);
            this.requestSocket.setSoTimeout(threadTimeout);
        }
        catch (SocketException ex) {
            // empty catch block
        }
    }

    private void connect_server(String hostname, int port) throws SocketException, IOException {
        this.sb.getLogger().debug((Object)"Enter connect_server().");
        InetSocketAddress endpoint = new InetSocketAddress(hostname, port);
        this.tgtSocket = new Socket();
        this.tgtSocket.setReceiveBufferSize(this.tcpbufsz);
        this.tgtSocket.setSendBufferSize(this.tcpbufsz);
        this.tgtSocket.setKeepAlive(true);
        this.tgtSocket.setTcpNoDelay(true);
        this.tgtSocket.connect(endpoint, this.connectionTimeout);
        this.svnsock_bis = new BufferedInputStream(this.tgtSocket.getInputStream(), this.tcpbufsz);
        this.svnsock_bos = new BufferedOutputStream(this.tgtSocket.getOutputStream(), this.tcpbufsz);
        this.sb.getLogger().debug((Object)"connect_server() is successful.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._run();
        }
        finally {
            try {
                this.tgtSocket.close();
                this.tgtSocket = null;
            }
            catch (IOException ex) {
                this.sb.getLogger().error((Object)("IOException closing targetSocket: " + ex.toString()));
            }
            try {
                this.requestSocket.close();
                this.requestSocket = null;
            }
            catch (IOException ex) {
                this.sb.getLogger().error((Object)("IOException closing requestSocket: " + ex.toString()));
            }
            this.sb.getLogger().debug((Object)"Connection accepted done!");
        }
    }

    private void _run() {
        try {
            this.connect_server("127.0.0.1", this.targetport);
        }
        catch (SocketTimeoutException ex) {
            this.sb.getLogger().fatal((Object)"Unable to connect svnserve backend. Server is forcely terminated.", (Throwable)ex);
            System.exit(-1);
        }
        catch (SocketException ex) {
            this.sb.getLogger().fatal((Object)"SocketException connecting svnserve. Server is forcely terminated.", (Throwable)ex);
            System.exit(-1);
        }
        catch (IOException ex) {
            this.sb.getLogger().fatal((Object)"IOException connection svnserve. Server is forcely terminated.", (Throwable)ex);
            System.exit(-1);
        }
        try {
            this.sock_bis = new BufferedInputStream(this.requestSocket.getInputStream(), this.tcpbufsz);
            this.sock_bos = new BufferedOutputStream(this.requestSocket.getOutputStream(), this.tcpbufsz);
        }
        catch (IOException ex) {
            this.sb.getLogger().error((Object)"IOException creating buffer: ", (Throwable)ex);
            return;
        }
        StreamGobblerDst2Command t1 = new StreamGobblerDst2Command(this.sock_bis, this.svnsock_bos);
        t1.setDaemon(true);
        t1.start();
        StreamGobblerCommand2Dst t2 = new StreamGobblerCommand2Dst(this.svnsock_bis, this.sock_bos);
        t2.setDaemon(true);
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch (InterruptedException ex) {
            this.sb.getLogger().debug((Object)"InterruptedException in thread join: ", (Throwable)ex);
        }
    }

    private class StreamGobblerCommand2Dst
    extends Thread {
        private BufferedInputStream bis = null;
        private BufferedOutputStream bos = null;

        public StreamGobblerCommand2Dst(BufferedInputStream bis, BufferedOutputStream bos) {
            this.setStreams(bis, bos);
        }

        public void setStreams(BufferedInputStream bis, BufferedOutputStream bos) {
            this.bis = bis;
            this.bos = bos;
        }

        private void flushBuffer(ByteBuffer buffer, int sz) throws Exception {
            if (sz > 0) {
                this.bos.write(buffer.array(), 0, sz);
                this.bos.flush();
                buffer.clear();
            }
        }

        @Override
        public void run() {
            boolean bClosed = false;
            ByteBuffer buffer = ByteBuffer.allocate(RequestThread.this.bufsz);
            do {
                int i;
                for (i = 0; i < RequestThread.this.bufsz; ++i) {
                    int c;
                    try {
                        if (this.bis.available() == 0) {
                            this.flushBuffer(buffer, i);
                            i = 0;
                        }
                        c = this.bis.read();
                        ++RequestThread.this.out_count;
                    }
                    catch (SocketException ex) {
                        bClosed = true;
                        RequestThread.this.sb.getLogger().debug((Object)("(IGNORABLE) StreamGobblerComand2Dst loop: " + ex.toString()));
                        break;
                    }
                    catch (Exception ex) {
                        bClosed = true;
                        RequestThread.this.sb.getLogger().error((Object)("Exception caught in StreamGobblerCommand2Dest(): " + ex.toString()));
                        break;
                    }
                    if (c == -1) {
                        bClosed = true;
                        break;
                    }
                    buffer.put(i, (byte)c);
                }
                try {
                    this.flushBuffer(buffer, i);
                }
                catch (Exception ex) {
                    bClosed = true;
                    RequestThread.this.sb.getLogger().error((Object)ex);
                }
            } while (!bClosed);
            try {
                RequestThread.this.sb.getLogger().debug((Object)"Enter close2");
                this.bis.close();
                this.bis = null;
            }
            catch (IOException ex) {
                RequestThread.this.sb.getLogger().error((Object)ex);
            }
            RequestThread.this.sb.getLogger().debug((Object)"StreamGobblerComand2Dst() exit peacefully.");
        }
    }

    private class StreamGobblerDst2Command
    extends Thread {
        private BufferedInputStream bis = null;
        private BufferedOutputStream bos = null;

        public StreamGobblerDst2Command(BufferedInputStream bis, BufferedOutputStream bos) {
            this.setStreams(bis, bos);
        }

        public void setStreams(BufferedInputStream bis, BufferedOutputStream bos) {
            this.bis = bis;
            this.bos = bos;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[RequestThread.this.bufsz];
            int len = 0;
            while (true) {
                try {
                    len = this.bis.read(buffer, 0, RequestThread.this.bufsz);
                }
                catch (SocketTimeoutException ex) {
                    RequestThread.this.sb.getLogger().debug((Object)("(Read timeout)StreamGobblerDst2Comand read()  : " + ex.toString()));
                    if (RequestThread.this.total_count < RequestThread.this.out_count) {
                        RequestThread.this.total_count = RequestThread.this.out_count;
                        continue;
                    }
                    RequestThread.this.sb.getLogger().error((Object)"(Read timeout) ALL THREADS SEEM NOT TO RUN, THREAD RECOVERY STARTED.");
                    try {
                        RequestThread.this.svnsock_bis.close();
                    }
                    catch (IOException ex2) {
                        RequestThread.this.sb.getLogger().debug((Object)"IOException closing svnsock_bis: ", (Throwable)ex2);
                    }
                    break;
                }
                catch (Exception ex) {
                    RequestThread.this.sb.getLogger().debug((Object)("StreamGobblerDst2Comand read() : " + ex.toString()));
                    break;
                }
                if (len == -1) break;
                try {
                    this.bos.write(buffer, 0, len);
                    this.bos.flush();
                }
                catch (Exception ex) {
                    RequestThread.this.sb.getLogger().debug((Object)("StreamGobblerDst2Comand write/flush() : " + ex.toString()));
                    break;
                }
            }
            try {
                RequestThread.this.sb.getLogger().debug((Object)"Enter close1");
                this.bos.flush();
                this.bos.close();
                this.bos = null;
            }
            catch (Exception ex) {
                RequestThread.this.sb.getLogger().error((Object)("StreamGobblerDst2Comand close(): " + ex.toString()));
            }
            RequestThread.this.sb.getLogger().debug((Object)"StreamGobblerDst2Comand() exit peacefully.");
        }
    }
}

