/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.serveradm;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.model.PropertyManager;
import com.interpress_project.modernshare.serveradm.CommandExecutor;
import com.interpress_project.modernshare.serveradm.exceptions.NoSVNInstalledException;
import com.interpress_project.modernshare.serveradm.exceptions.RepositoryException;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public class SVNRepositoryManager {
    private final SystemBase sb = SystemBase.getInstance();
    private PropertyManager propmgr = PropertyManager.getInstance();
    private String svnadmin = null;

    public SVNRepositoryManager() {
        try {
            this.svnadmin = this.propmgr.getSVNAdminCommand();
        }
        catch (NoSVNInstalledException ex) {
            this.sb.getLogger().fatal((Object)ex.getMessage(), (Throwable)ex);
            System.exit(-1);
        }
        String targetDir = this.propmgr.getSVNBackupdir();
        File dir = new File(targetDir);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                this.sb.getLogger().fatal((Object)("Unable to create the backup directory, " + targetDir + ". Server is forcely terminated."));
                System.exit(-1);
            }
            this.sb.getLogger().warn((Object)("The backup directory " + targetDir + " created."));
        }
        if (!dir.isDirectory()) {
            if (!dir.delete()) {
                this.sb.getLogger().fatal((Object)"Tried to create backup directory, but found the plain file there.");
                this.sb.getLogger().fatal((Object)("Unable to delete file, " + targetDir + ". Server is forcely terminated."));
                System.exit(-1);
            }
            if (!dir.mkdirs()) {
                this.sb.getLogger().fatal((Object)("Unable to create the backup directory, " + targetDir + ". Server is forcely terminated."));
                System.exit(-1);
            }
            this.sb.getLogger().warn((Object)("The backup directory " + targetDir + " created."));
        }
        if (this.existRepository()) {
            try {
                this.cleanTransaction();
            }
            catch (RepositoryException ex) {
                this.sb.getLogger().fatal((Object)ex.toString());
                System.exit(-1);
            }
            return;
        }
        try {
            this.createRepository();
        }
        catch (RepositoryException ex) {
            this.sb.getLogger().fatal((Object)ex.toString());
            System.exit(-1);
        }
    }

    private boolean existRepository() {
        String rootdir = this.propmgr.getSVNRootdir();
        File file = new File(rootdir);
        if (!file.exists()) {
            return false;
        }
        return file.isDirectory();
    }

    public void createRepository() throws RepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        String rootdir = this.propmgr.getSVNRootdir();
        this.sb.getLogger().debug((Object)"Enter createRepository()");
        this.sb.getLogger().info((Object)("Creating new repository in " + rootdir + ". It may take time ..."));
        try {
            list.add(this.svnadmin);
            list.add("create");
            if (this.propmgr.hasBdbused()) {
                list.add("--fs-type");
                list.add("bdb");
            }
            list.add(rootdir);
            new CommandExecutor(true).execute(list);
        }
        catch (Throwable ex) {
            throw new RepositoryException(ex);
        }
        this.sb.getLogger().info((Object)"Creating new repository done.");
    }

    public void cleanTransaction() throws RepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        int retval = -1;
        this.sb.getLogger().warn((Object)"Cleaning up the repository. It may take time ...");
        String rootdir = this.propmgr.getSVNRootdir();
        try {
            list.add(this.svnadmin);
            list.add("recover");
            list.add(rootdir);
            retval = new CommandExecutor(true).execute(list);
        }
        catch (Throwable ex) {
            throw new RepositoryException(ex);
        }
        if (retval != 0) {
            throw new RepositoryException("Fail to clean up the repository.(" + list.toString() + ")");
        }
        this.sb.getLogger().warn((Object)"Cleaning up done.");
    }

    public String backup() throws Throwable {
        ArrayList<String> list = new ArrayList<String>();
        String srcDir = this.propmgr.getSVNRootdir();
        String d = this.sb.getDateUtil().getDateTimeAsDecimal(new Date());
        String targetDir = this.propmgr.getSVNBackupdir();
        targetDir = targetDir + "/" + d;
        this.sb.getLogger().info((Object)("Backing up the repository to " + targetDir + ". It may take time ..."));
        try {
            list.add(this.svnadmin);
            list.add("hotcopy");
            list.add(srcDir);
            list.add(targetDir);
            new CommandExecutor(true).execute(list);
        }
        catch (Throwable ex) {
            throw new RepositoryException("Fail to back up the repository.(" + list.toString() + ")");
        }
        this.sb.getLogger().info((Object)"Backing up done.");
        return d;
    }
}

