/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.serveradm;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.model.AccountManager;
import com.interpress_project.modernshare.model.PropertyManager;
import com.interpress_project.modernshare.model.UserConfigDAO;
import com.interpress_project.modernshare.orb.MdsClientInfoFactory;
import com.interpress_project.modernshare.orb.MdsServerInfoFactory;
import com.interpress_project.modernshare.orb.generated.MdsClientInfoHelper;
import com.interpress_project.modernshare.orb.generated.MdsServerInfoHelper;
import com.interpress_project.modernshare.serveradm.MdsServiceImpl;
import com.interpress_project.modernshare.serveradm.SVNRepositoryManager;
import java.util.Properties;
import org.jacorb.sasPolicy.SASPolicyValues;
import org.jacorb.sasPolicy.SASPolicyValuesHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ThreadPolicyValue;

public class ORBManager
extends Thread {
    private SystemBase sb = SystemBase.getInstance();
    private PropertyManager propmgr = PropertyManager.getInstance();
    private ORB orb;
    private POA poaRoot;
    private POA poaFactory = null;
    private int processors = Runtime.getRuntime().availableProcessors();
    private UserConfigDAO xmldao = new UserConfigDAO();

    public ORBManager(String[] args, AccountManager acctmgr, SVNRepositoryManager repmgr) {
        Properties props = System.getProperties();
        props.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        props.setProperty("custom.props", "etc/jacorb.properties");
        props.setProperty("jacorb.suppress_no_props_warning", "on");
        props.setProperty("jacorb.security.sas.contextClass", "com.interpress_project.modernshare.serveradm.ListGssUpContext");
        props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.SAS", "org.jacorb.security.sas.SASInitializer");
        props.setProperty("org.omg.PortableInterceptor.ORBInitializerClass.GSSUPProvider", "org.jacorb.security.sas.GSSUPProviderInitializer");
        props.setProperty("OAIAddr", this.propmgr.getServerName());
        props.setProperty("OASSLPort", this.propmgr.getAdminport());
        props.setProperty("jacorb.security.keystore", this.propmgr.getKeystore());
        props.setProperty("jacorb.security.keystore_password", this.propmgr.getKeystorePass());
        try {
            this.orb = (ORB)org.omg.CORBA.ORB.init((String[])args, (Properties)props);
            this.orb.register_value_factory(MdsServerInfoHelper.id(), (ValueFactory)new MdsServerInfoFactory());
            this.orb.register_value_factory(MdsClientInfoHelper.id(), (ValueFactory)new MdsClientInfoFactory());
            Object obj = this.orb.resolve_initial_references("RootPOA");
            this.poaRoot = POAHelper.narrow((Object)obj);
            Any sasAny = this.orb.create_any();
            SASPolicyValuesHelper.insert((Any)sasAny, (SASPolicyValues)new SASPolicyValues(64, 64, true));
            Policy[] MyServerFactoryPolicies = new Policy[]{this.poaRoot.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), this.poaRoot.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.poaRoot.create_thread_policy(ThreadPolicyValue.ORB_CTRL_MODEL), this.orb.create_policy(102, sasAny)};
            this.poaFactory = this.poaRoot.create_POA("MyFactory_poa", this.poaRoot.the_POAManager(), MyServerFactoryPolicies);
            MdsServiceImpl servant = new MdsServiceImpl(this.orb, acctmgr, repmgr, this.xmldao);
            this.poaFactory.activate_object_with_id("MyFactory".getBytes(), (Servant)servant);
            this.poaRoot.the_POAManager().activate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.sb.getLogger().fatal((java.lang.Object)ex.getMessage());
            this.sb.getLogger().fatal((java.lang.Object)"Fail to start up ORB. Server is forcely terminated.");
            System.exit(-1);
        }
    }

    @Override
    public void run() {
        String actual = this.propmgr.getServerName();
        this.sb.getLogger().info((java.lang.Object)("ORB hostname : " + actual));
        this.sb.getLogger().info((java.lang.Object)("ORB Max CPU : " + this.processors));
        String virtual = this.propmgr.getVirtualServerName();
        if (!virtual.equalsIgnoreCase(actual)) {
            this.sb.getLogger().info((java.lang.Object)("ORB Virtual host : " + virtual));
        }
        this.sb.getLogger().info((java.lang.Object)("ORB port : " + this.propmgr.getAdminport()));
        this.sb.getLogger().info((java.lang.Object)"ORB started.");
        this.orb.run();
    }

    public void shutdown() {
        this.xmldao.dispose();
        this.orb.shutdown(false);
        this.orb = null;
    }
}

