/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.serveradm;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.model.AccountManager;
import com.interpress_project.modernshare.model.PropertyManager;
import com.interpress_project.modernshare.model.UserConfigDAO;
import com.interpress_project.modernshare.model.exceptions.AccountExistException;
import com.interpress_project.modernshare.model.exceptions.AccountNotExistException;
import com.interpress_project.modernshare.model.exceptions.LicenseException;
import com.interpress_project.modernshare.orb.MdsClientInfoImpl;
import com.interpress_project.modernshare.orb.generated.AccountExist;
import com.interpress_project.modernshare.orb.generated.AccountNotFound;
import com.interpress_project.modernshare.orb.generated.InternalError;
import com.interpress_project.modernshare.orb.generated.LicenseError;
import com.interpress_project.modernshare.orb.generated.MdsClientInfo;
import com.interpress_project.modernshare.orb.generated.MdsServerInfo;
import com.interpress_project.modernshare.orb.generated.MdsServicePOA;
import com.interpress_project.modernshare.orb.generated.NoPrivilege;
import com.interpress_project.modernshare.serveradm.SVNRepositoryManager;
import com.interpress_project.modernshare.serveradm.exceptions.RepositoryException;
import org.jacorb.security.sas.SASInitializer;
import org.omg.CORBA.Any;
import org.omg.CORBA_2_3.ORB;
import org.omg.PortableInterceptor.Current;

public class MdsServiceImpl
extends MdsServicePOA {
    private SystemBase sb = SystemBase.getInstance();
    private PropertyManager propmgr;
    private AccountManager acctmgr;
    private SVNRepositoryManager repmgr;
    private ORB orb = null;
    private UserConfigDAO xmldao;

    public MdsServiceImpl(ORB orb, AccountManager acctmgr, SVNRepositoryManager repmgr, UserConfigDAO xmldao) {
        this.orb = orb;
        this.acctmgr = acctmgr;
        this.repmgr = repmgr;
        this.propmgr = PropertyManager.getInstance();
        this.xmldao = xmldao;
    }

    private String getCurrentAccount() {
        String accountName = null;
        try {
            Current current = (Current)this.orb.resolve_initial_references("PICurrent");
            Any anyName = current.get_slot(SASInitializer.sasPrincipalNamePIC);
            accountName = anyName.extract_string();
        }
        catch (Exception ex) {
            this.sb.getLogger().error((Object)"Exception accessing PICurrent: ", (Throwable)ex);
        }
        return accountName;
    }

    public void addUser(String account, String password) throws InternalError, NoPrivilege, AccountExist, LicenseError {
        this.sb.getLogger().info((Object)("Adding new account for " + account + " ..."));
        if (!this.getCurrentAccount().equals(this.propmgr.getAdministratorAccount())) {
            throw new NoPrivilege();
        }
        try {
            this.acctmgr.addUser(account, password);
        }
        catch (AccountExistException ex) {
            throw new AccountExist(ex.getLocalizedMessage());
        }
        catch (LicenseException ex) {
            throw new LicenseError();
        }
        this.sb.getLogger().info((Object)"Adding new account is successful.");
    }

    public void deleteUser(String account) throws AccountNotFound, NoPrivilege {
        this.sb.getLogger().info((Object)("Deleting account for " + account + " ..."));
        if (!this.getCurrentAccount().equals(this.propmgr.getAdministratorAccount())) {
            throw new NoPrivilege();
        }
        try {
            this.acctmgr.deleteUser(account);
        }
        catch (AccountNotExistException ex) {
            throw new AccountNotFound(ex.getLocalizedMessage());
        }
        this.sb.getLogger().info((Object)"Deleting account is successful.");
    }

    public MdsServerInfo getServerInfo() {
        return null;
    }

    public void changePassword(String account, String newpass) throws AccountNotFound {
        this.sb.getLogger().info((Object)("Changing password for " + account + " ..."));
        try {
            this.acctmgr.changePassword(account, newpass);
        }
        catch (AccountNotExistException ex) {
            throw new AccountNotFound(ex.getMessage());
        }
        this.sb.getLogger().info((Object)"Changing password is successful.");
    }

    public String backup() throws InternalError, NoPrivilege {
        String dir = null;
        if (!this.getCurrentAccount().equals(this.propmgr.getAdministratorAccount())) {
            throw new NoPrivilege();
        }
        try {
            this.repmgr.cleanTransaction();
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            dir = this.repmgr.backup();
        }
        catch (Throwable ex) {
            throw new InternalError(ex.getMessage());
        }
        return dir;
    }

    public void recovery() throws InternalError, NoPrivilege {
        if (!this.getCurrentAccount().equals(this.propmgr.getAdministratorAccount())) {
            throw new NoPrivilege();
        }
        try {
            this.repmgr.cleanTransaction();
        }
        catch (RepositoryException ex) {
            throw new InternalError(ex.getCause().getMessage());
        }
    }

    public MdsClientInfo getClientInfo(String account, String clientid) {
        this.sb.getLogger().debug((Object)("Enter getClientInfo(" + account + ", " + clientid + ")"));
        String xmldata = this.xmldao.find(account, clientid);
        if (xmldata == null) {
            xmldata = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><configure xmlns=\"http://www.interpress.co.jp/hotshot/client\"></configure>";
        }
        return new MdsClientInfoImpl(account, clientid, xmldata);
    }

    public void setClientInfo(MdsClientInfo info) {
        this.sb.getLogger().debug((Object)("Enter setClientInfo(" + info.getAccount() + ", " + info.getClientId() + ")"));
        this.xmldao.add(info.getAccount(), info.getClientId(), info.getXMLdata());
    }
}

