/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.serveradm;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.serveradm.exceptions.CommandExecutorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class CommandExecutor {
    private final SystemBase sb = SystemBase.getInstance();
    private ProcessBuilder processBuilder;
    private Process process;
    private boolean bWaitFor = false;

    public CommandExecutor(boolean bWaitFor) {
        this.bWaitFor = bWaitFor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(ArrayList<String> cmdlist) throws CommandExecutorException {
        InputStream is = null;
        InputStream errs = null;
        int rcode = 0;
        try {
            this.processBuilder = new ProcessBuilder(cmdlist);
            this.processBuilder = this.processBuilder.redirectErrorStream(true);
            this.process = this.processBuilder.start();
            this.process.getOutputStream().close();
            is = this.process.getInputStream();
            errs = this.process.getErrorStream();
        }
        catch (Exception ex) {
            throw new CommandExecutorException("Command execute failed: " + ex.getMessage());
        }
        StreamGobbler sg = new StreamGobbler(is);
        sg.start();
        try {
            if (this.bWaitFor) {
                rcode = this.process.waitFor();
            }
        }
        catch (InterruptedException ex) {
            this.sb.getLogger().warn((Object)("InterupptedException waiting for command done: " + ex.getMessage()));
        }
        finally {
            try {
                is.close();
                errs.close();
            }
            catch (IOException ex) {
                this.sb.getLogger().error((Object)("IOException closing command streams: " + ex.getMessage()));
            }
        }
        return rcode;
    }

    public void destroy() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    private class StreamGobbler
    extends Thread {
        private InputStream is;

        public StreamGobbler(InputStream is) {
            this.setStream(is);
        }

        public void setStream(InputStream is) {
            this.is = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            try {
                while ((line = br.readLine()) != null) {
                    CommandExecutor.this.sb.getLogger().info((Object)line);
                }
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

