/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.model;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.model.PropertyManager;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.btree.BTree;
import jdbm.helper.StringComparator;

public class UserConfigDAO {
    private final SystemBase sb = SystemBase.getInstance();
    private final PropertyManager propmgr = PropertyManager.getInstance();
    private RecordManager recman;
    private BTree btree;

    public UserConfigDAO() {
        this.sb.getLogger().debug((Object)"Enter UserConfigDAO()");
        Properties props = new Properties();
        String dbname = this.propmgr.getXMLDBFileName();
        try {
            this.recman = RecordManagerFactory.createRecordManager((String)dbname, (Properties)props);
            long recid = this.recman.getNamedObject("HotShotServer");
            if (recid != 0L) {
                this.sb.getLogger().debug((Object)"XMLDB reloading exist one");
                this.btree = BTree.load((RecordManager)this.recman, (long)recid);
            } else {
                this.sb.getLogger().debug((Object)"XMLDB creating new one");
                this.btree = BTree.createInstance((RecordManager)this.recman, (Comparator)new StringComparator());
                this.recman.setNamedObject("HotShotServer", this.btree.getRecid());
            }
        }
        catch (Exception ex) {
            this.sb.getLogger().fatal((Object)"XMLDB must be corrupted so please re-boot HotShot Server. Server is terminated forcely.", (Throwable)ex);
            new File(dbname + ".db").delete();
            new File(dbname + ".lg").delete();
            System.exit(-1);
        }
        this.sb.getLogger().debug((Object)"XMLDB opened.");
    }

    public synchronized void add(String account, String clientid, String value) {
        String key = this.mkkey(account, clientid);
        this.sb.getLogger().debug((Object)("Enter add(" + key + ")"));
        try {
            this.btree.insert((Object)key, (Object)value, true);
            this.recman.commit();
        }
        catch (Exception ex) {
            this.sb.getLogger().error((Object)("XMLDB add(" + key + ") failed : " + ex.getMessage()));
            try {
                this.recman.rollback();
            }
            catch (IOException ex2) {
                // empty catch block
            }
        }
        this.sb.getLogger().debug((Object)("Leave add(" + key + ")"));
    }

    public synchronized void delete(String account, String clientid) {
        String key = this.mkkey(account, clientid);
        this.sb.getLogger().debug((Object)("Enter delete(" + key + ")"));
        try {
            this.btree.remove((Object)key);
            this.recman.commit();
        }
        catch (Exception ex) {
            this.sb.getLogger().error((Object)("XMLDB delete(" + key + ") failed : "), (Throwable)ex);
            try {
                this.recman.rollback();
            }
            catch (IOException ex2) {
                // empty catch block
            }
        }
        this.sb.getLogger().debug((Object)("Leave delete(" + key + ")"));
    }

    public String find(String account, String clientid) {
        String key = this.mkkey(account, clientid);
        String xmldata = null;
        this.sb.getLogger().debug((Object)("Enter find(" + key + ")"));
        try {
            xmldata = (String)this.btree.find((Object)key);
            if (xmldata == null) {
                this.sb.getLogger().debug((Object)("XML config data not found (" + key + ")"));
            }
        }
        catch (Exception ex) {
            this.sb.getLogger().warn((Object)("XMLDB find(" + key + ") failed : "), (Throwable)ex);
        }
        this.sb.getLogger().debug((Object)("Leave find(" + key + ")"));
        return xmldata;
    }

    private String mkkey(String account, String clientid) {
        String key = account + clientid;
        return key.toLowerCase();
    }

    public void dispose() {
        if (this.recman != null) {
            try {
                this.recman.close();
                this.recman = null;
            }
            catch (IOException ex) {
                this.sb.getLogger().error((Object)"IOException closing XMLDB:", (Throwable)ex);
            }
        }
        this.sb.getLogger().debug((Object)"XMLDB closed.");
    }
}

