/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.model;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.serveradm.exceptions.NoSVNInstalledException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public class PropertyManager {
    private final SystemBase sb = SystemBase.getInstance();
    private File propfile = null;
    private Properties prop = new Properties();
    private static PropertyManager instance;

    protected PropertyManager() {
    }

    public void initialize(String filename) {
        this.propfile = new File(FilenameUtils.normalize((String)filename));
        this.load();
        this.sb.getLogger().info((Object)("HotShot server properties located in " + this.propfile.getAbsolutePath()));
        this.sb.getLogger().info((Object)("Administartor account : " + this.getAdministratorAccount()));
        this.sb.getLogger().info((Object)("Administrator name : " + this.getAdministrator()));
        this.sb.getLogger().info((Object)("Administrator mail : " + this.getAdministratorEmail()));
        this.sb.getLogger().info((Object)("HotShot directory : " + this.sb.getCurrentDirectory()));
        this.sb.getLogger().info((Object)("Repository directory : " + this.getSVNRootdir()));
        this.sb.getLogger().info((Object)("Repository backup directory : " + this.getSVNBackupdir()));
        try {
            this.sb.getLogger().info((Object)("SVN system directory : " + this.getSVNHome()));
        }
        catch (NoSVNInstalledException noSVNInstalledException) {
            // empty catch block
        }
    }

    private void load() {
        this.sb.getLogger().debug((Object)"Enter load().");
        try {
            this.prop.load(new FileInputStream(this.propfile));
        }
        catch (FileNotFoundException ex) {
            this.sb.getLogger().error((Object)("Property file " + this.propfile.getAbsolutePath() + " not found. Server is forcely terminated."), (Throwable)ex);
            System.exit(-1);
        }
        catch (IOException ex) {
            this.sb.getLogger().fatal((Object)"IOException loading properties. Server is forcely terminated.", (Throwable)ex);
            System.exit(-1);
        }
        this.sb.getLogger().debug((Object)"Leave load().");
    }

    public void save() throws FileNotFoundException, IOException {
        this.prop.store(new FileOutputStream("etc/server.properties"), "Properties for HotShot server.");
    }

    public String getAdminport() {
        return this.prop.getProperty("hotshot.server.port", "17770");
    }

    public String getAdministrator() {
        return this.prop.getProperty("hotshot.server.administrator", "unknown");
    }

    public String getAdministratorEmail() {
        return this.prop.getProperty("hotshot.server.administrator.email", "unknown@unknown.com");
    }

    public String getAdministratorAccount() {
        return this.prop.getProperty("hotshot.server.administrator.account", "root");
    }

    public String getAdministratorPassword() {
        return this.prop.getProperty("hotshot.server.administrator.password", "masterkey");
    }

    public String getSVNHome() throws NoSVNInstalledException {
        String homepath = this.prop.getProperty("hotshot.svn.home", "./svn");
        File file = new File(FilenameUtils.normalize((String)homepath));
        if (file.isDirectory()) {
            return file.getAbsolutePath();
        }
        String msg = "Couldn't find out SubVersion system directory: " + file.getAbsolutePath() + "\n" + "Please specify the svn directory with " + "hotshot.svn.home" + " in " + this.propfile;
        throw new NoSVNInstalledException(msg);
    }

    public String getSVNAdminCommand() throws NoSVNInstalledException {
        String homepath = this.getSVNHome();
        homepath = homepath + "/bin/" + "svnadmin";
        File file = new File(FilenameUtils.normalize((String)homepath));
        return file.getAbsolutePath();
    }

    public int getSVNServerThreadMinimum() {
        String min = this.prop.getProperty("hotshot.server.svnserver.pool.min", "16");
        return Integer.parseInt(min);
    }

    public int getSVNServerThreadMaximum() {
        String max = this.prop.getProperty("hotshot.server.svnserver.pool.max", "64");
        return Integer.parseInt(max);
    }

    public String getServerName() {
        String hostname = "localhost";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        String host = this.prop.getProperty("hotshot.server.host", hostname);
        return host;
    }

    public String getVirtualServerName() {
        String hostname = this.prop.getProperty("hotshot.server.virtualhost", this.getServerName());
        return hostname.trim();
    }

    public int getSVNServerPort() {
        String port = this.prop.getProperty("hotshot.server.svnserver.port", "3690");
        return Integer.parseInt(port.trim());
    }

    public String getSVNRootdir() {
        String p = this.prop.getProperty("hotshot.server.svnserver.rootdir", "./hotshot_repository.d");
        File f = new File(FilenameUtils.normalize((String)p));
        return f.getAbsolutePath();
    }

    public String getSVNBackupdir() {
        String p = this.prop.getProperty("hotshot.server.svnserver.backupdir", "./hotshot_repository_backup.d");
        File f = new File(FilenameUtils.normalize((String)p));
        return f.getAbsolutePath();
    }

    public boolean hasBdbused() {
        String type = this.prop.getProperty("hotshot.server.svnserver.bdb", "true");
        return type.equalsIgnoreCase("true");
    }

    public int getTcpBufSz() {
        String sz = this.prop.getProperty("hotshot.network.tcpbufsz", "32768");
        return Integer.parseInt(sz);
    }

    public String getSVNServerCommand() throws NoSVNInstalledException {
        String homepath = this.getSVNHome();
        homepath = homepath + "/bin/" + "svnserve";
        File file = new File(FilenameUtils.normalize((String)homepath));
        return file.getAbsolutePath();
    }

    public String getSVNServerCommandPort() {
        String port = this.prop.getProperty("hotshot.server.svnserver.command.port", "55535");
        return port;
    }

    public void setKeystore(String s) {
        this.prop.setProperty("hotshot.network.ssl.keystore.file", s);
    }

    public String getKeystore() {
        return this.prop.getProperty("hotshot.network.ssl.keystore.file", "jsse_server_ks");
    }

    public void setKeystorePass(String s) {
        this.prop.setProperty("hotshot.network.ssl.keystore.password", s);
    }

    public String getKeystorePass() {
        return this.prop.getProperty("hotshot.network.ssl.keystore.password", "jsse_server_ks_pass");
    }

    public String getXMLDBFileName() {
        String path = this.getSVNRootdir();
        path = path + "/" + "dbxml";
        return FilenameUtils.normalize((String)path);
    }

    public int getThreadTimeout() {
        String s = this.prop.getProperty("hotshot.server.secureguard.timeout", "180000");
        return Integer.valueOf(s);
    }

    public static PropertyManager getInstance() {
        if (instance == null) {
            instance = new PropertyManager();
        }
        return instance;
    }
}

