/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.model;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.model.INIFile;
import com.interpress_project.modernshare.model.PropertyManager;
import com.interpress_project.modernshare.model.exceptions.AccountExistException;
import com.interpress_project.modernshare.model.exceptions.AccountNotExistException;
import com.interpress_project.modernshare.model.exceptions.LicenseException;
import java.util.Map;

public class AccountManager {
    private final SystemBase sb = SystemBase.getInstance();
    private final String filesep = this.sb.getFileSeparator();
    private final Object lock = new Object();
    private PropertyManager propmgr = PropertyManager.getInstance();
    private INIFile iniSvnconfig = null;
    private static INIFile iniPassword = null;
    private INIFile iniAuthz = null;

    public AccountManager() {
        String rootdir = this.propmgr.getSVNRootdir();
        String passwd = rootdir + this.filesep + "conf" + this.filesep + "passwd";
        String authz = rootdir + this.filesep + "conf" + this.filesep + "authz";
        String svnconf = rootdir + this.filesep + "conf" + this.filesep + "svnserve.conf";
        iniPassword = new INIFile(passwd);
        this.iniAuthz = new INIFile(authz);
        this.iniSvnconfig = new INIFile(svnconf);
        this.initializeConfigFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConfigFiles() {
        String account = this.propmgr.getAdministratorAccount();
        String password = this.propmgr.getAdministratorPassword();
        Object object = this.lock;
        synchronized (object) {
            this.iniSvnconfig.setStringProperty("general", "anon-access", "none", "");
            this.iniSvnconfig.setStringProperty("general", "auth-access", "write", "");
            this.iniSvnconfig.setStringProperty("general", "password-db", "passwd", "");
            this.iniSvnconfig.setStringProperty("general", "authz-db", "authz", "");
            this.iniSvnconfig.save();
            this.iniAuthz.setStringProperty("/", account, "rw", "");
            this.iniAuthz.setStringProperty("/", "*", "", "");
            this.iniAuthz.save();
            iniPassword.setStringProperty("users", account, password, "");
            iniPassword.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String account, String password) throws AccountExistException, LicenseException {
        Object object = this.lock;
        synchronized (object) {
            if (this.existUser(account)) {
                throw new AccountExistException();
            }
            iniPassword.setStringProperty("users", account, password, "");
            iniPassword.save();
            this.iniAuthz.setStringProperty("/", account, "rw", "");
            this.iniAuthz.setStringProperty("/" + account, account, "rw", "");
            this.iniAuthz.setStringProperty("/" + account, this.propmgr.getAdministratorAccount(), "rw", "");
            this.iniAuthz.setStringProperty("/" + account, "*", "", "");
            this.iniAuthz.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUser(String account) throws AccountNotExistException {
        if (!this.existUser(account)) {
            throw new AccountNotExistException();
        }
        Object object = this.lock;
        synchronized (object) {
            iniPassword.removeProperty("users", account);
            iniPassword.save();
            this.iniAuthz.removeProperty("/", account);
            this.iniAuthz.removeSection("/" + account);
            this.iniAuthz.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(String account, String newpass) throws AccountNotExistException {
        if (!this.existUser(account)) {
            throw new AccountNotExistException();
        }
        Object object = this.lock;
        synchronized (object) {
            iniPassword.setStringProperty("users", account, newpass, "");
            iniPassword.save();
        }
    }

    private boolean existUser(String account) {
        Map map = iniPassword.getProperties("users");
        return map.containsKey(account);
    }

    public int getNumberOfAccounts() {
        Map map = iniPassword.getProperties("users");
        return map.size();
    }

    public static boolean authenticate(String account, String password) {
        String passwd = iniPassword.getStringProperty("users", account);
        if (passwd == null) {
            return false;
        }
        return password.equals(passwd);
    }
}

