/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare;

import com.interpress_project.modernshare.ipcommon.SystemBase;
import com.interpress_project.modernshare.model.AccountManager;
import com.interpress_project.modernshare.model.PropertyManager;
import com.interpress_project.modernshare.serveradm.ORBManager;
import com.interpress_project.modernshare.serveradm.SVNRepositoryManager;
import com.interpress_project.modernshare.svnserver.SVNServeManager;
import com.interpress_project.modernshare.svnserver.ServerManager;

public class Container {
    private final SystemBase sb = SystemBase.getInstance();
    private ORBManager orbmgr;
    private ServerManager svnmgr;
    private SVNRepositoryManager repmgr;
    private AccountManager acctmgr;
    private SVNServeManager svnsrvmgr;

    public Container(String[] args) {
        this.sb.setLoggerInfo("HotShot_Server", "etc/log4j.properties");
        this.sb.getLogger().info((Object)"HotShot Server is being started...");
        String propfile = "etc/server.properties";
        for (int i = 0; i < args.length; ++i) {
            if (!"-propfile".equalsIgnoreCase(args[i])) continue;
            propfile = args[++i];
        }
        PropertyManager.getInstance().initialize(propfile);
        this.repmgr = new SVNRepositoryManager();
        this.acctmgr = new AccountManager();
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
    }

    private void run(String[] args) {
        this.orbmgr = new ORBManager(args, this.acctmgr, this.repmgr);
        this.orbmgr.start();
        try {
            this.orbmgr.join(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.svnmgr = new ServerManager();
        this.svnmgr.start();
        try {
            this.svnmgr.join(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.svnsrvmgr = new SVNServeManager();
        this.svnsrvmgr.start();
        try {
            this.svnsrvmgr.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.sb.getLogger().info((Object)"HotShot Server is ready.");
    }

    public static void main(String[] args) {
        new Container(args).run(args);
        try {
            while (true) {
                Thread.sleep(30000L);
            }
        }
        catch (Exception ex) {
            return;
        }
    }

    public static void stop() {
        SystemBase.getInstance().getLogger().warn((Object)"Service termination hook called.");
        System.exit(0);
    }

    private class ShutdownHook
    extends Thread {
        private final SystemBase sb = SystemBase.getInstance();

        private ShutdownHook() {
        }

        @Override
        public void run() {
            this.sb.getLogger().info((Object)"HotShot Server shutdown started.");
            if (Container.this.svnmgr != null) {
                Container.this.svnmgr.shutdown();
            }
            if (Container.this.orbmgr != null) {
                Container.this.orbmgr.shutdown();
            }
            if (Container.this.svnsrvmgr != null) {
                Container.this.svnsrvmgr.dispose();
            }
            this.sb.getLogger().info((Object)"HotShot Server shutdown finished.");
        }
    }
}

