/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.util.HashMap;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.Security.AttributeType;
import org.omg.Security.ExtensibleFamily;
import org.omg.SecurityLevel2.Current;

public class ServerInvocationInterceptor
extends LocalObject
implements ServerRequestInterceptor,
Configurable {
    public static final String DEFAULT_NAME = "ServerInvocationInterceptor";
    private String name = "ServerInvocationInterceptor";
    private AttributeType type = null;
    private HashMap sessionCredentials = new HashMap();
    private Logger logger;
    private short serverSupportedOptions = 0;
    private short serverRequiredOptions = 0;

    public ServerInvocationInterceptor(Current current, ORB oRB) throws ConfigurationException {
        this.type = new AttributeType(new ExtensibleFamily(0, 1), 2);
        this.configure(oRB.getConfiguration());
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.security.ssl.interceptor");
        this.serverSupportedOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.serverRequiredOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        CertificateFactory certificateFactory;
        SSLSocket sSLSocket;
        block12: {
            ServerRequest serverRequest = ((ServerRequestInfoImpl)serverRequestInfo).request;
            GIOPConnection gIOPConnection = serverRequest.getConnection();
            if (gIOPConnection == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("target has no connection!");
                }
                return;
            }
            if (!gIOPConnection.isSSL()) {
                return;
            }
            ServerIIOPConnection serverIIOPConnection = (ServerIIOPConnection)gIOPConnection.getTransport();
            sSLSocket = (SSLSocket)serverIIOPConnection.getSocket();
            SSLSession sSLSession = sSLSocket.getSession();
            if (this.sessionCredentials.containsKey(sSLSession)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Reusing SSL session credentials.");
                }
                return;
            }
            certificateFactory = null;
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            catch (Exception exception) {
                if (!this.logger.isWarnEnabled()) break block12;
                this.logger.warn(exception.getMessage());
            }
        }
        try {
            X509Certificate[] x509CertificateArray = sSLSocket.getSession().getPeerCertificateChain();
            int n = x509CertificateArray.length;
            java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[n];
            for (int i = n - 1; 0 <= i; --i) {
                x509CertificateArray2[i] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509CertificateArray[i].getEncoded()));
            }
        }
        catch (Exception exception) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception " + exception.getMessage() + " in ServerInvocationInterceptor");
            }
            if ((this.serverRequiredOptions & 0x40) != 0) {
                throw new NO_PERMISSION("Establish trust in client required, but failed");
            }
            return;
        }
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        this.removeAttribute();
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.removeAttribute();
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.removeAttribute();
    }

    private void removeAttribute() {
    }
}

