/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.etf.ListenerBase;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPLoopback;
import org.jacorb.orb.iiop.IIOPLoopbackConnection;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackRegistry;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.listener.AcceptorExceptionEvent;
import org.jacorb.orb.listener.AcceptorExceptionListener;
import org.jacorb.orb.listener.SSLListenerUtil;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Connection;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class IIOPListener
extends ListenerBase {
    private static final int MAX_SSL_OPTIONS = 126;
    private static final int MIN_SSL_OPTIONS = 26;
    private SocketFactoryManager socketFactoryManager = null;
    private SSLAcceptor sslAcceptor = null;
    private LoopbackAcceptor loopbackAcceptor;
    private boolean supportSSL = false;
    private int serverTimeout = 0;
    private IIOPAddress address = null;
    private IIOPAddress sslAddress = null;
    private int target_supports = 0;
    private int target_requires = 0;
    private boolean generateSSLComponents = true;
    static /* synthetic */ Class class$org$jacorb$orb$listener$DefaultAcceptorExceptionListener;

    public void configure(Configuration configuration) throws ConfigurationException {
        String string;
        ProtocolAddressBase protocolAddressBase;
        super.configure(configuration);
        this.socketFactoryManager = this.orb.getTransportManager().getSocketFactoryManager();
        String string2 = configuration.getAttribute("OAAddress", null);
        if (string2 != null) {
            protocolAddressBase = this.orb.createAddress(string2);
            if (protocolAddressBase instanceof IIOPAddress) {
                this.address = (IIOPAddress)protocolAddressBase;
            }
        } else {
            int n = configuration.getAttributeAsInteger("OAPort", 0);
            string = configuration.getAttribute("OAIAddr", "");
            this.address = new IIOPAddress(string, n);
        }
        if (this.address != null) {
            this.address.configure(configuration);
        }
        if ((string2 = configuration.getAttribute("OASSLAddress", null)) != null) {
            protocolAddressBase = this.orb.createAddress(string2);
            if (protocolAddressBase instanceof IIOPAddress) {
                this.sslAddress = (IIOPAddress)protocolAddressBase;
            }
        } else {
            int n = configuration.getAttributeAsInteger("OASSLPort", 0);
            string = configuration.getAttribute("OAIAddr", "");
            this.sslAddress = new IIOPAddress(string, n);
        }
        if (this.sslAddress != null) {
            this.sslAddress.configure(configuration);
        }
        this.serverTimeout = configuration.getAttributeAsInteger("jacorb.connection.server.timeout", 0);
        this.supportSSL = configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        this.target_supports = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.target_supports |= 0x1A;
        this.target_requires = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
        this.generateSSLComponents = configuration.getAttribute("jacorb.security.ssl_components_added_by_ior_interceptor", "off").equals("off");
        if (!this.isSSLRequired() || configuration.getAttributeAsBoolean("jacorb.security.ssl.always_open_unsecured_address", false)) {
            this.acceptor = new Acceptor("ServerSocketListener");
            ((Acceptor)this.acceptor).init();
        }
        if (this.supportSSL) {
            this.sslAcceptor = new SSLAcceptor();
            this.sslAcceptor.init();
        }
        this.loopbackAcceptor = new LoopbackAcceptor();
        this.profile = this.createAddressProfile();
    }

    public void listen() {
        super.listen();
        if (this.sslAcceptor != null) {
            this.sslAcceptor.start();
        }
        this.loopbackAcceptor.start();
    }

    public void destroy() {
        this.loopbackAcceptor.terminate();
        if (this.sslAcceptor != null) {
            this.sslAcceptor.terminate();
        }
        super.destroy();
    }

    public void renewSSLServerSocket() {
        if (this.sslAcceptor != null) {
            this.sslAcceptor.renewSSLServerSocket();
        }
    }

    private boolean isSSLSupported() {
        return this.supportSSL;
    }

    private boolean isSSLRequired() {
        if (this.isSSLSupported()) {
            return (this.target_requires & 0x7E) != 0;
        }
        return false;
    }

    private IIOPProfile createAddressProfile() throws ConfigurationException {
        if (this.acceptor != null) {
            if (this.address.getPort() == 0) {
                this.address.setPort(((Acceptor)this.acceptor).getLocalAddress().getPort());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using port " + this.address.getPort());
            }
        } else if (this.sslAcceptor == null) {
            throw new INITIALIZE("no acceptors found, cannot create address profile");
        }
        IIOPProfile iIOPProfile = new IIOPProfile(this.address, null);
        if (this.sslAcceptor != null && this.generateSSLComponents) {
            iIOPProfile.addComponent(20, this.createSSL(), SSLHelper.class);
        }
        iIOPProfile.configure(this.configuration);
        return iIOPProfile;
    }

    private SSL createSSL() {
        return new SSL((short)this.target_supports, (short)this.target_requires, (short)this.sslAcceptor.getLocalAddress().getPort());
    }

    private void deliverConnection(Socket socket, boolean bl) {
        Connection connection = null;
        try {
            connection = this.createServerConnection(socket, bl);
        }
        catch (IOException iOException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Could not create connection from socket: ", iOException);
            }
            return;
        }
        this.deliverConnection(connection);
    }

    protected Connection createServerConnection(Socket socket, boolean bl) throws IOException {
        TCPConnectionListener tCPConnectionListener = this.socketFactoryManager.getTCPListener();
        ServerIIOPConnection serverIIOPConnection = new ServerIIOPConnection(socket, bl, tCPConnectionListener);
        if (tCPConnectionListener.isListenerEnabled()) {
            tCPConnectionListener.connectionOpened(new TCPConnectionEvent(serverIIOPConnection, socket.getInetAddress().getHostAddress(), socket.getPort(), socket.getLocalPort(), this.getLocalhost()));
        }
        try {
            serverIIOPConnection.configure(this.configuration);
        }
        catch (ConfigurationException configurationException) {
            throw new INTERNAL("ConfigurationException: " + configurationException.toString());
        }
        return serverIIOPConnection;
    }

    private String getLocalhost() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to resolve local host - using default 127.0.0.1");
            }
            string = "127.0.0.1";
        }
        return string;
    }

    static /* synthetic */ Logger access$700(IIOPListener iIOPListener) {
        return iIOPListener.logger;
    }

    static /* synthetic */ Logger access$800(IIOPListener iIOPListener) {
        return iIOPListener.logger;
    }

    private class LoopbackAcceptor
    implements IIOPLoopback {
        private LoopbackAcceptor() {
        }

        public void start() {
            IIOPLoopbackRegistry.getRegistry().register(this.getAddress(), this);
        }

        public void terminate() {
            IIOPLoopbackRegistry.getRegistry().unregister(this.getAddress());
        }

        public void initLoopback(IIOPLoopbackInputStream iIOPLoopbackInputStream, IIOPLoopbackOutputStream iIOPLoopbackOutputStream) {
            IIOPLoopbackConnection iIOPLoopbackConnection = new IIOPLoopbackConnection(iIOPLoopbackInputStream, iIOPLoopbackOutputStream);
            IIOPListener.this.deliverConnection(iIOPLoopbackConnection);
        }

        private IIOPAddress getAddress() {
            IIOPProfile iIOPProfile = (IIOPProfile)IIOPListener.this.profile;
            return (IIOPAddress)iIOPProfile.getAddress();
        }
    }

    private class SSLAcceptor
    extends Acceptor {
        private final Object renewSocketSync;
        private boolean renewingSocket;
        private boolean blockedOnAccept;
        private final int soTimeout;

        private SSLAcceptor() {
            super("SSLServerSocketListener");
            this.renewSocketSync = new Object();
            this.soTimeout = IIOPListener.this.configuration.getAttributeAsInteger("jacorb.listener.server_socket_timeout", 0);
        }

        protected ServerSocket createServerSocket() {
            try {
                int n = IIOPListener.this.sslAddress.getPort();
                InetAddress inetAddress = IIOPListener.this.sslAddress.getConfiguredHost();
                ServerSocket serverSocket = this.newServerSocket(n, inetAddress);
                return serverSocket;
            }
            catch (IOException iOException) {
                IIOPListener.this.logger.warn("could not create SSL server socket", iOException);
                throw new INITIALIZE("Could not create SSL server socket");
            }
        }

        private ServerSocket newServerSocket(int n, InetAddress inetAddress) throws IOException {
            ServerSocket serverSocket = IIOPListener.this.socketFactoryManager.getSSLServerSocketFactory().createServerSocket(n, 20, inetAddress);
            if (this.soTimeout > 0) {
                this.serverSocket.setSoTimeout(this.soTimeout);
            }
            return serverSocket;
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void beginAccept() throws InterruptedException {
            Object object = this.renewSocketSync;
            synchronized (object) {
                while (this.renewingSocket) {
                    this.renewSocketSync.wait();
                }
                this.blockedOnAccept = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void endAccept() {
            Object object = this.renewSocketSync;
            synchronized (object) {
                this.blockedOnAccept = false;
                this.renewSocketSync.notifyAll();
            }
        }

        protected void doHandleExceptionInRunLoop(Exception exception, boolean bl) {
            if (!(exception instanceof InterruptedException)) {
                return;
            }
            if (this.soTimeout > 0) {
                return;
            }
            if (bl) {
                return;
            }
            IIOPListener.this.logger.warn("InterruptedException should only occur if soTimeout > 0", exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renewSSLServerSocket() {
            Object object;
            int n = this.serverSocket.getLocalPort();
            InetAddress inetAddress = this.serverSocket.getInetAddress();
            try {
                object = this.renewSocketSync;
                synchronized (object) {
                    this.renewingSocket = true;
                    while (this.blockedOnAccept) {
                        try {
                            this.renewSocketSync.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                try {
                    this.serverSocket.close();
                }
                catch (Exception exception) {
                    IIOPListener.this.logger.warn("failed to close SSLServerSocket", exception);
                }
                try {
                    this.serverSocket = this.newServerSocket(n, inetAddress);
                }
                catch (Exception exception) {
                    IIOPListener.this.logger.warn("Failed to create SSLServerSocket", exception);
                    throw new INITIALIZE("Could not create SSL server socket: " + exception);
                }
            }
            finally {
                object = this.renewSocketSync;
                synchronized (object) {
                    this.renewingSocket = false;
                    this.renewSocketSync.notifyAll();
                }
            }
        }
    }

    public class Acceptor
    extends ListenerBase.Acceptor {
        private final Object runSync = new Object();
        private final boolean keepAlive;
        protected ServerSocket serverSocket;
        protected boolean terminated = false;
        private final AcceptorExceptionListener acceptorExceptionListener;
        private boolean firstPass;

        protected Acceptor(String string) {
            this.setDaemon(true);
            this.setName(string);
            this.keepAlive = IIOPListener.this.configuration.getAttributeAsBoolean("jacorb.connection.server.keepalive", false);
            try {
                this.acceptorExceptionListener = (AcceptorExceptionListener)IIOPListener.this.configuration.getAttributeAsObject("jacorb.acceptor_exception_listener", (class$org$jacorb$orb$listener$DefaultAcceptorExceptionListener == null ? (class$org$jacorb$orb$listener$DefaultAcceptorExceptionListener = IIOPListener.class$("org.jacorb.orb.listener.DefaultAcceptorExceptionListener")) : class$org$jacorb$orb$listener$DefaultAcceptorExceptionListener).getName());
            }
            catch (ConfigurationException configurationException) {
                IIOPListener.this.logger.error("couldn't create a AcceptorExceptionListener", configurationException);
                throw new IllegalArgumentException("wrong configuration: " + configurationException);
            }
        }

        public void init() {
            this.serverSocket = this.createServerSocket();
            if (IIOPListener.this.logger.isDebugEnabled()) {
                IIOPListener.this.logger.debug("Created socket listener on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort());
            }
        }

        protected void beginAccept() throws InterruptedException {
        }

        protected void endAccept() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public final void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        var1_1 = this.runSync;
                        synchronized (var1_1) {
                            if (this.terminated) {
                                if (IIOPListener.access$700(IIOPListener.this).isInfoEnabled()) {
                                    IIOPListener.access$800(IIOPListener.this).info("Listener exited");
                                }
                                return;
                            }
                        }
                        this.beginAccept();
                        try {
                            var1_1 = this.serverSocket.accept();
                            this.setup((Socket)var1_1);
                            this.deliverConnection((Socket)var1_1);
                            this.firstPass = true;
                        }
                        finally {
                            this.endAccept();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception var1_2) {
                    var2_3 = this.runSync;
                    synchronized (var2_3) {
                        this.handleExceptionInRunLoop(var1_2, this.terminated);
                        continue;
                    }
                }
                ** GOTO lbl-1000
            }
        }

        private void handleExceptionInRunLoop(Exception exception, boolean bl) {
            if (!bl) {
                IIOPListener.this.logger.warn("unexpected exception in runloop", exception);
            }
            this.acceptorExceptionListener.exceptionCaught(new AcceptorExceptionEvent(this, ((BasicAdapter)IIOPListener.this.up).getORB(), exception));
        }

        protected void doHandleExceptionInRunLoop(Exception exception, boolean bl) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            block5: {
                Object object = this.runSync;
                synchronized (object) {
                    this.terminated = true;
                }
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    if (!IIOPListener.this.logger.isWarnEnabled()) break block5;
                    IIOPListener.this.logger.warn("failed to close ServerSocket", iOException);
                }
            }
            this.interrupt();
        }

        public IIOPAddress getLocalAddress() {
            IIOPAddress iIOPAddress;
            block3: {
                iIOPAddress = new IIOPAddress(this.serverSocket.getInetAddress().toString(), this.serverSocket.getLocalPort());
                if (IIOPListener.this.configuration != null) {
                    try {
                        iIOPAddress.configure(IIOPListener.this.configuration);
                    }
                    catch (ConfigurationException configurationException) {
                        if (!IIOPListener.this.logger.isWarnEnabled()) break block3;
                        IIOPListener.this.logger.warn("ConfigurationException", configurationException);
                    }
                }
            }
            return iIOPAddress;
        }

        protected ServerSocket createServerSocket() {
            try {
                return IIOPListener.this.socketFactoryManager.getServerSocketFactory().createServerSocket(IIOPListener.this.address.getPort(), 20, IIOPListener.this.address.getConfiguredHost());
            }
            catch (IOException iOException) {
                IIOPListener.this.logger.warn("could not create server socket port: " + IIOPListener.this.address.getPort() + " host: " + IIOPListener.this.address.getConfiguredHost(), iOException);
                throw new INITIALIZE("Could not create server socket (" + IIOPListener.this.address.getPort() + "): " + iOException.toString());
            }
        }

        protected final void setup(Socket socket) throws IOException {
            socket.setSoTimeout(IIOPListener.this.serverTimeout);
            socket.setKeepAlive(this.keepAlive);
            SSLListenerUtil.addListener(IIOPListener.this.orb, socket);
            this.doSetup(socket);
        }

        protected void doSetup(Socket socket) {
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, false);
        }

        public boolean getAcceptorSocketLoop() {
            return this.firstPass;
        }
    }
}

