/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.io.Serializable;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Duration
implements Serializable {
    private static final long serialVersionUID = -6475091654291323029L;
    private static final Log LOG = LogFactory.getLog(class$org$exolab$castor$types$Duration == null ? (class$org$exolab$castor$types$Duration = Duration.class$("org.exolab.castor.types.Duration")) : class$org$exolab$castor$types$Duration);
    private static final boolean DEBUG = false;
    private static final int TIME_FLAG = 8;
    private short _year = 0;
    private short _month = 0;
    private short _day = 0;
    private short _hour = 0;
    private short _minute = 0;
    private short _second = 0;
    private long _millisecond = 0L;
    private boolean _isNegative = false;
    static /* synthetic */ Class class$org$exolab$castor$types$Duration;

    public Duration() {
    }

    public Duration(String duration) throws ParseException {
        Duration.parseDurationInternal(duration, this);
    }

    public Duration(long l) {
        long refSecond = 1000L;
        long refMinute = 60L * refSecond;
        long refHour = 60L * refMinute;
        long refDay = 24L * refHour;
        long refMonth = (long)(30.42 * (double)refDay);
        long refYear = 12L * refMonth;
        if (l < 0L) {
            this.setNegative();
            l = -l;
        }
        short year = (short)(l / refYear);
        short month = (short)((l %= refYear) / refMonth);
        short day = (short)((l %= refMonth) / refDay);
        short hour = (short)((l %= refDay) / refHour);
        short minute = (short)((l %= refHour) / refMinute);
        short seconds = (short)((l %= refMinute) / refSecond);
        long milliseconds = l %= refSecond;
        this.setValue(year, month, day, hour, minute, seconds, milliseconds);
    }

    public void setYear(short year) {
        if (year < 0) {
            String err = "In a duration all fields have to be positive.";
            throw new IllegalArgumentException(err);
        }
        this._year = year;
    }

    public void setMonth(short month) {
        if (month < 0) {
            String err = "In a duration all fields have to be positive.";
            throw new IllegalArgumentException(err);
        }
        this._month = month;
    }

    public void setDay(short day) {
        if (day < 0) {
            String err = "In a duration all fields have to be positive.";
            throw new IllegalArgumentException(err);
        }
        this._day = day;
    }

    public void setHour(short hour) {
        if (hour < 0) {
            String err = "In a duration all fields have to be positive.";
            throw new IllegalArgumentException(err);
        }
        this._hour = hour;
    }

    public void setMinute(short minute) {
        if (minute < 0) {
            String err = "In a duration all fields have to be positive.";
            throw new IllegalArgumentException(err);
        }
        this._minute = minute;
    }

    public void setSeconds(short second) {
        if (second < 0) {
            String err = "In a duration all fields have to be positive.";
            throw new IllegalArgumentException(err);
        }
        this._second = second;
    }

    public void setMilli(long milli) {
        if (milli < 0L) {
            String err = "In a duration all fields have to be positive.";
            throw new IllegalArgumentException(err);
        }
        this._millisecond = milli;
    }

    public void setNegative() {
        this._isNegative = true;
    }

    public void setValue(short year, short month, short day, short hour, short minute, short second, long millisecond) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSeconds(second);
        this.setMilli(millisecond);
    }

    public short getYear() {
        return this._year;
    }

    public short getMonth() {
        return this._month;
    }

    public short getDay() {
        return this._day;
    }

    public short getHour() {
        return this._hour;
    }

    public short getMinute() {
        return this._minute;
    }

    public short getSeconds() {
        return this._second;
    }

    public long getMilli() {
        return this._millisecond;
    }

    public boolean isNegative() {
        return this._isNegative;
    }

    public long toLong() {
        long result = 0L;
        result = (long)((((((double)((long)this._year * 12L + (long)this._month) * 30.42 + (double)this._day) * 24.0 + (double)this._hour) * 60.0 + (double)this._minute) * 60.0 + (double)this._second) * 1000.0 + (double)this._millisecond);
        result = this.isNegative() ? -result : result;
        return result;
    }

    public String toString() {
        boolean isThereTime;
        if (this.toLong() == 0L) {
            return "PT0S";
        }
        StringBuffer result = new StringBuffer();
        if (this._isNegative) {
            result.append('-');
        }
        result.append("P");
        if (this._year != 0) {
            result.append(this._year);
            result.append('Y');
        }
        if (this._month != 0) {
            result.append(this._month);
            result.append('M');
        }
        if (this._day != 0) {
            result.append(this._day);
            result.append('D');
        }
        boolean bl = isThereTime = this._hour != 0 || this._minute != 0 || this._second != 0 || this._millisecond != 0L;
        if (isThereTime) {
            result.append('T');
            if (this._hour != 0) {
                result.append(this._hour);
                result.append('H');
            }
            if (this._minute != 0) {
                result.append(this._minute);
                result.append('M');
            }
            if (this._second != 0 || this._millisecond != 0L) {
                result.append(this._second);
                if (this._millisecond != 0L) {
                    result.append('.');
                    if (this._millisecond < 100L) {
                        result.append('0');
                        if (this._millisecond < 10L) {
                            result.append('0');
                        }
                    }
                    result.append(this._millisecond);
                }
                result.append('S');
            }
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return Duration.parseDuration(str);
    }

    public static Duration parseDuration(String str) throws ParseException {
        Duration result = new Duration();
        return Duration.parseDurationInternal(str, result);
    }

    private static Duration parseDurationInternal(String str, Duration result) throws ParseException {
        int idx;
        char[] chars;
        if (str == null) {
            throw new IllegalArgumentException("the string to be parsed must not be null");
        }
        if (str.length() == 0) {
            return null;
        }
        if (result == null) {
            result = new Duration();
        }
        if ((chars = str.toCharArray())[idx = 0] == '-') {
            result.setNegative();
            if (++idx >= chars.length) {
                throw new ParseException("'-' is wrongly placed", 0);
            }
        }
        if (chars[idx] != 'P') {
            throw new ParseException("Missing 'P' delimiter", idx);
        }
        if (++idx == chars.length) {
            throw new ParseException("Bad format for a duration:" + str, idx);
        }
        int number = 0;
        boolean hasNumber = false;
        int flags = 0;
        block9: while (idx < chars.length) {
            char ch = chars[idx++];
            switch (ch) {
                case 'Y': {
                    String err;
                    if (flags > 0) {
                        err = str + ":Syntax error, 'Y' must proceed all other delimiters.";
                        throw new ParseException(err, idx);
                    }
                    flags = 64;
                    if (hasNumber) {
                        result.setYear((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    err = str + ":missing number of years before 'Y'";
                    throw new ParseException(err, idx);
                }
                case 'M': {
                    String err;
                    if ((flags & 8) == 8) {
                        if ((flags & 3) > 0) {
                            throw new ParseException(str + ": Syntax Error...", idx);
                        }
                        flags |= 2;
                        if (hasNumber) {
                            result.setMinute((short)number);
                            hasNumber = false;
                            continue block9;
                        }
                        err = str + ": missing number of minutes before 'M'";
                        throw new ParseException(err, idx);
                    }
                    if ((flags & 0x3F) > 0) {
                        throw new ParseException(str + ":Syntax Error...", idx);
                    }
                    flags |= 0x20;
                    if (hasNumber) {
                        result.setMonth((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    err = str + ":missing number of months before 'M'";
                    throw new ParseException(err, idx);
                }
                case 'D': {
                    if ((flags & 0x1F) > 0) {
                        throw new ParseException(str + ":Syntax Error...", idx);
                    }
                    flags |= 0x10;
                    if (hasNumber) {
                        result.setDay((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    String err = str + ":missing number of days before 'D'";
                    throw new ParseException(err, idx);
                }
                case 'T': {
                    String err;
                    if ((flags & 8) == 8) {
                        err = str + ":Syntax error, 'T' may not " + "exist more than once.";
                        throw new ParseException(err, idx);
                    }
                    flags |= 8;
                    continue block9;
                }
                case 'H': {
                    String err;
                    if ((flags & 0xF) != 8) {
                        err = null;
                        err = (flags & 8) != 8 ? str + ": Missing 'T' before 'H'" : str + ": Syntax Error, 'H' must appear for 'M' or 'S'";
                        throw new ParseException(err, idx);
                    }
                    flags |= 4;
                    if (hasNumber) {
                        result.setHour((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    err = str + ":missing number of hours before 'H'";
                    throw new ParseException(err, idx);
                }
                case 'S': {
                    String err;
                    if (flags != 0) {
                        if ((flags & 8) != 8) {
                            err = str + ": Missing 'T' before 'S'";
                            throw new ParseException(err, idx);
                        }
                        if ((flags & 1) == 1) {
                            err = str + ": Syntax error 'S' may not exist more than once.";
                            throw new ParseException(err, idx);
                        }
                        flags |= 1;
                        if (hasNumber) {
                            result.setSeconds((short)number);
                            hasNumber = false;
                            continue block9;
                        }
                        err = str + ": missing number of seconds before 'S'";
                        throw new ParseException(err, idx);
                    }
                    if (hasNumber) {
                        String numb = Integer.toString(number);
                        if (numb.length() < 3) {
                            if (numb.length() < 2) {
                                number *= 10;
                            }
                            number *= 10;
                        }
                        result.setMilli(number);
                        hasNumber = false;
                        continue block9;
                    }
                    err = str + ": missing number of milliseconds before 'S'";
                    throw new ParseException(err, idx);
                }
                case '.': {
                    String err;
                    if ((flags & 8) != 8) {
                        err = str + ": Missing 'T' before 'S'";
                        throw new ParseException(err, idx);
                    }
                    if ((flags | 1) == 1) {
                        err = str + ": Syntax error '.' may not exist more than once.";
                        throw new ParseException(err, idx);
                    }
                    flags = 0;
                    if (hasNumber) {
                        result.setSeconds((short)number);
                        hasNumber = false;
                        continue block9;
                    }
                    err = str + ": missing number of seconds before 'S'";
                    throw new ParseException(err, idx);
                }
            }
            if ('0' <= ch && ch <= '9') {
                if (hasNumber) {
                    number = number * 10 + (ch - 48);
                    continue;
                }
                hasNumber = true;
                number = ch - 48;
                continue;
            }
            throw new ParseException(str + ":Invalid character: " + ch, idx);
        }
        if ((flags & 0xF) == 8) {
            LOG.warn("Warning: " + str + ": T shall be omitted");
        }
        if (hasNumber) {
            throw new ParseException(str + ": expecting ending delimiter", idx);
        }
        return result;
    }

    public int hashCode() {
        return 37 * (this._year ^ this._month ^ this._day ^ this._hour ^ this._minute ^ this._second);
    }

    public boolean equals(Object object) {
        if (object instanceof Duration) {
            return this.equal((Duration)object);
        }
        return false;
    }

    public boolean equal(Duration duration) {
        boolean result = false;
        if (duration == null) {
            return result;
        }
        result = this._year == duration.getYear();
        result = result && this._month == duration.getMonth();
        result = result && this._day == duration.getDay();
        result = result && this._hour == duration.getHour();
        result = result && this._minute == duration.getMinute();
        result = result && this._second == duration.getSeconds();
        result = result && this._millisecond == duration.getMilli();
        result = result && this.isNegative() == duration.isNegative();
        return result;
    }

    public boolean isGreater(Duration duration) {
        boolean result = false;
        result = this.toLong() > duration.toLong();
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

