/*
 * Decompiled with CFR 0.152.
 */
package com.interpress_project.modernshare.ipcommon;

import com.interpress_project.modernshare.ipcommon.DateUtilImpl;
import com.interpress_project.modernshare.ipcommon.SystemUtilImpl;
import java.text.DecimalFormat;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class SystemBase {
    private static SystemBase instance = null;
    private static Logger logger = null;
    private static SystemUtilImpl utilImpl = null;
    private String userHome;
    private String fileSeparator;
    private String lineSeparator;
    private String pathSeparator;
    private String tmpDir;
    private String currDir;
    private String osName;
    private DateUtilImpl dateUtilImpl;

    protected SystemBase() {
        Properties prop = System.getProperties();
        this.userHome = prop.getProperty("user.home");
        this.currDir = prop.getProperty("user.dir");
        this.fileSeparator = prop.getProperty("file.separator");
        this.lineSeparator = prop.getProperty("line.separator");
        this.pathSeparator = prop.getProperty("path.separator");
        this.tmpDir = prop.getProperty("java.io.tmpdir");
        this.osName = prop.getProperty("os.name").toUpperCase();
    }

    public static synchronized SystemBase getInstance() {
        if (instance == null) {
            instance = new SystemBase();
        }
        return instance;
    }

    public void setLoggerInfo(String loggerName, String propFileName) {
        PropertyConfigurator.configure((String)propFileName);
        logger = Logger.getLogger((String)loggerName);
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public String getTmpDirectory() {
        return this.tmpDir;
    }

    public String getUserHomeDirectory() {
        return this.userHome;
    }

    public String getCurrentDirectory() {
        return this.currDir;
    }

    public String getSVNAdminCommand() {
        if (this.osName.startsWith("WINDOWS") || this.osName.startsWith("OS/2")) {
            return "svnadmin.exe";
        }
        return "svnadmin";
    }

    public String getSVNServeCommand() {
        if (this.osName.startsWith("WINDOWS") || this.osName.startsWith("OS/2")) {
            return "svnserve.exe";
        }
        return "svnserve";
    }

    public Logger getLogger() {
        return logger;
    }

    public SystemUtilImpl getSystemUtil() {
        if (utilImpl == null) {
            utilImpl = new SystemUtilImpl();
        }
        return utilImpl;
    }

    public DateUtilImpl getDateUtil() {
        if (this.dateUtilImpl == null) {
            this.dateUtilImpl = new DateUtilImpl();
        }
        return this.dateUtilImpl;
    }

    public String gc() {
        DecimalFormat df = new DecimalFormat("###,###,###.###");
        Runtime rt = Runtime.getRuntime();
        long total = rt.totalMemory();
        long free = rt.freeMemory();
        long used = total - free;
        float f = (float)used / (float)total;
        String msg = "Total: " + df.format(total / 1000000L) + "MB ";
        msg = msg + "[before] used: " + used + "(" + f * 100.0f + "%) ";
        rt.gc();
        free = rt.freeMemory();
        used = total - free;
        f = (float)used / (float)total;
        msg = msg + "[after] used: " + used + "(" + f * 100.0f + "%) ";
        return msg;
    }
}

