/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import org.tigris.subversion.javahl.Info2;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;

public class JhlInfo2
implements ISVNInfo {
    private Info2 info;
    private File file;

    public JhlInfo2(File file, Info2 info) {
        this.file = file;
        this.info = info;
    }

    public File getFile() {
        try {
            return this.file.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
    }

    public SVNUrl getUrl() {
        try {
            return new SVNUrl(this.info.getUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getUrlString() {
        return this.info.getUrl();
    }

    public String getUuid() {
        return this.info.getReposUUID();
    }

    public SVNUrl getRepository() {
        try {
            return new SVNUrl(this.info.getReposRootUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public SVNScheduleKind getSchedule() {
        return JhlConverter.convertScheduleKind(this.info.getSchedule());
    }

    public SVNNodeKind getNodeKind() {
        return JhlConverter.convertNodeKind(this.info.getKind());
    }

    public String getLastCommitAuthor() {
        return this.info.getLastChangedAuthor();
    }

    public SVNRevision.Number getRevision() {
        return JhlConverter.convertRevisionNumber(this.info.getRev());
    }

    public SVNRevision.Number getLastChangedRevision() {
        return JhlConverter.convertRevisionNumber(this.info.getLastChangedRev());
    }

    public Date getLastChangedDate() {
        return this.info.getLastChangedDate();
    }

    public Date getLastDateTextUpdate() {
        return this.info.getTextTime();
    }

    public Date getLastDatePropsUpdate() {
        return this.info.getPropTime();
    }

    public boolean isCopied() {
        return this.info.getCopyFromRev() > 0L;
    }

    public SVNRevision.Number getCopyRev() {
        return JhlConverter.convertRevisionNumber(this.info.getCopyFromRev());
    }

    public SVNUrl getCopyUrl() {
        try {
            return new SVNUrl(this.info.getCopyFromUrl());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Date getLockCreationDate() {
        if (this.info.getLock() == null) {
            return null;
        }
        return this.info.getLock().getCreationDate();
    }

    public String getLockOwner() {
        if (this.info.getLock() == null) {
            return null;
        }
        return this.info.getLock().getOwner();
    }

    public String getLockComment() {
        if (this.info.getLock() == null) {
            return null;
        }
        return this.info.getLock().getComment();
    }
}

