/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public abstract class SVNNotificationHandler {
    protected List notifylisteners = new ArrayList();
    protected int command;
    protected boolean logEnabled = true;
    protected File baseDir = new File(".");

    public void add(ISVNNotifyListener listener) {
        this.notifylisteners.add(listener);
    }

    public void remove(ISVNNotifyListener listener) {
        this.notifylisteners.remove(listener);
    }

    public void enableLog() {
        this.logEnabled = true;
    }

    public void disableLog() {
        this.logEnabled = false;
    }

    public void logMessage(String message) {
        if (this.logEnabled) {
            Iterator it = this.notifylisteners.iterator();
            while (it.hasNext()) {
                ISVNNotifyListener listener = (ISVNNotifyListener)it.next();
                listener.logMessage(message);
            }
        }
    }

    public void logError(String message) {
        if (this.logEnabled) {
            Iterator it = this.notifylisteners.iterator();
            while (it.hasNext()) {
                ISVNNotifyListener listener = (ISVNNotifyListener)it.next();
                listener.logError(message);
            }
        }
    }

    public void logRevision(long revision, String path) {
        if (this.logEnabled) {
            Iterator it = this.notifylisteners.iterator();
            while (it.hasNext()) {
                ISVNNotifyListener listener = (ISVNNotifyListener)it.next();
                listener.logRevision(revision, path);
            }
        }
    }

    public void logCompleted(String message) {
        if (this.logEnabled) {
            Iterator it = this.notifylisteners.iterator();
            while (it.hasNext()) {
                ISVNNotifyListener listener = (ISVNNotifyListener)it.next();
                listener.logCompleted(message);
            }
        }
    }

    public void setCommand(int command) {
        this.command = command;
        Iterator it = this.notifylisteners.iterator();
        while (it.hasNext()) {
            ISVNNotifyListener listener = (ISVNNotifyListener)it.next();
            listener.setCommand(command);
        }
    }

    public void logCommandLine(String commandLine) {
        if (this.logEnabled && !this.skipCommand()) {
            Iterator it = this.notifylisteners.iterator();
            while (it.hasNext()) {
                ISVNNotifyListener listener = (ISVNNotifyListener)it.next();
                listener.logCommandLine(commandLine);
            }
        }
    }

    public void logException(Exception clientException) {
        if (this.logEnabled) {
            for (Throwable e = clientException; e != null; e = e.getCause()) {
                this.logError(e.getMessage());
            }
        }
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setBaseDir() {
        this.baseDir = new File(".");
    }

    private File getAbsoluteFile(String path) {
        if (path == null) {
            return null;
        }
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(this.baseDir, path);
        }
        return f;
    }

    public void notifyListenersOfChange(String path) {
        if (path == null) {
            return;
        }
        File f = this.getAbsoluteFile(path);
        if (f == null) {
            this.logMessage("Warning : invalid path :" + path);
            return;
        }
        SVNNodeKind kind = f.isFile() ? SVNNodeKind.FILE : (f.isDirectory() ? SVNNodeKind.DIR : SVNNodeKind.UNKNOWN);
        Iterator it = this.notifylisteners.iterator();
        while (it.hasNext()) {
            ISVNNotifyListener listener = (ISVNNotifyListener)it.next();
            listener.onNotify(f, kind);
        }
    }

    public void notifyListenersOfChange(String path, SVNNodeKind kind) {
        if (path == null) {
            return;
        }
        File f = this.getAbsoluteFile(path);
        if (f == null) {
            this.logMessage("Warning : invalid path :" + path);
            return;
        }
        Iterator it = this.notifylisteners.iterator();
        while (it.hasNext()) {
            ISVNNotifyListener listener = (ISVNNotifyListener)it.next();
            listener.onNotify(f, kind);
        }
    }

    protected boolean skipCommand() {
        return this.command == 18 || this.command == 19 || this.command == 13 || this.command == 11 || this.command == 20 || this.command == 21 || this.command == 12;
    }
}

