/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi.bitmap;

import com.jniwrapper.win32.gdi.bitmap.Bitmap16BitBuilder;
import com.jniwrapper.win32.gdi.bitmap.Bitmap24BitBuilder;
import com.jniwrapper.win32.gdi.bitmap.Bitmap32BitBuilder;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilder;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilderFactory;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilderIndexColorModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;

public class BitmapBuilderFactoryImpl
implements BitmapBuilderFactory {
    private static final String NO_IMPL_MSG = "There isn't builder for specified color model. Color model = ";

    @Override
    public BitmapBuilder createBuilder(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return this.createBuilderByIndexModel(bufferedImage);
        }
        if (colorModel instanceof DirectColorModel) {
            return this.createBuilderByDirectModel(bufferedImage);
        }
        if (colorModel instanceof ComponentColorModel) {
            return this.createBuilderByComponentModel(bufferedImage);
        }
        throw new RuntimeException(NO_IMPL_MSG + colorModel);
    }

    private BitmapBuilder createBuilderByIndexModel(BufferedImage bufferedImage) {
        if (!(bufferedImage.getColorModel() instanceof IndexColorModel)) {
            throw new RuntimeException("Must be IndexColorModel");
        }
        IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
        if (indexColorModel.getPixelSize() <= 8 && indexColorModel.getMapSize() <= 256) {
            int bitCount = 0;
            bitCount = indexColorModel.getMapSize() <= 2 ? 1 : (indexColorModel.getMapSize() <= 16 ? 4 : 8);
            return new BitmapBuilderIndexColorModel(bitCount, bufferedImage);
        }
        throw new RuntimeException(NO_IMPL_MSG);
    }

    private BitmapBuilder createBuilderByDirectModel(BufferedImage bufferedImage) {
        int pixelSize = bufferedImage.getColorModel().getPixelSize();
        if (pixelSize <= 8 || pixelSize > 32) {
            throw new RuntimeException(NO_IMPL_MSG);
        }
        if (pixelSize <= 16) {
            return new Bitmap16BitBuilder(bufferedImage);
        }
        if (pixelSize <= 24) {
            return new Bitmap24BitBuilder(bufferedImage);
        }
        return new Bitmap32BitBuilder(bufferedImage);
    }

    private BitmapBuilder createBuilderByComponentModel(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel().hasAlpha()) {
            return new Bitmap32BitBuilder(bufferedImage);
        }
        return new Bitmap24BitBuilder(bufferedImage);
    }
}

