/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32;

import com.jniwrapper.win32.LastError;

public class LastErrorException
extends RuntimeException {
    private long _errorCode;

    public LastErrorException() {
        this._errorCode = LastError.getValue();
    }

    public LastErrorException(long errorCode) {
        this._errorCode = errorCode;
    }

    public LastErrorException(String message) {
        super(message);
        this._errorCode = LastError.getValue();
    }

    public LastErrorException(long errorCode, String message) {
        super(message);
        this._errorCode = errorCode;
    }

    public LastErrorException(String message, boolean clearError) {
        super(message);
        this._errorCode = LastError.getValue();
        if (clearError) {
            LastError.clearLastErrorCode();
        }
    }

    public LastErrorException(long errorCode, String message, boolean clearError) {
        super(message);
        this._errorCode = errorCode;
        if (clearError) {
            LastError.clearLastErrorCode();
        }
    }

    public LastErrorException(Throwable cause) {
        super(cause.getMessage());
        this._errorCode = LastError.getValue();
    }

    public LastErrorException(long errorCode, Throwable cause) {
        super(cause.getMessage());
        this._errorCode = errorCode;
    }

    public LastErrorException(String message, Throwable cause) {
        super(message, cause);
    }

    public long getErrorCode() {
        return this._errorCode;
    }

    public String getErrorMessage() {
        return LastError.getMessage(this.getErrorCode());
    }

    @Override
    public String getMessage() {
        String detailsMessage = super.getMessage();
        if (detailsMessage == null || detailsMessage.length() == 0) {
            return this.getErrorMessage();
        }
        return detailsMessage + " " + this.getErrorMessage();
    }
}

